/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.IntList;
import blbutil.IntMap;
import blbutil.IntSet;
import phase.PhaseData;
import phase.PhaseIbs;

public final class PhaseStates {
    private final PhaseIbs ibsHaps;
    private final int nStates;
    private final IntMap<CopyHap> hap2Slots;
    private final CopyHap[] slotHeap;
    private final IntList[] copyHaps;

    public PhaseStates(PhaseIbs phaseIbs) {
        this.ibsHaps = phaseIbs;
        this.nStates = phaseIbs.nStates();
        this.hap2Slots = new IntMap(this.nStates);
        this.slotHeap = new CopyHap[this.nStates];
        this.copyHaps = new IntList[this.nStates];
        for (int i = 0; i < this.nStates; ++i) {
            this.slotHeap[i] = new CopyHap(i);
            this.copyHaps[i] = new IntList(10);
        }
    }

    public int nStates() {
        return this.ibsHaps.nStates();
    }

    public int ibsStates(int n, int[][] nArray) {
        int n2;
        long l = System.nanoTime();
        int n3 = 2 * n;
        int n4 = 2 * n + 1;
        this.initializeFields();
        int n5 = this.ibsHaps.nSteps();
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            IntSet intSet = this.ibsHaps.ibsHaps(n3, n4, n2);
            int n7 = intSet.size();
            for (n6 = 0; n6 < n7; ++n6) {
                this.updateFields(intSet.elementWithIndex(n6), n2);
            }
            intSet = this.ibsHaps.ibsHaps(n4, n3, n2);
            n7 = intSet.size();
            for (n6 = 0; n6 < n7; ++n6) {
                this.updateFields(intSet.elementWithIndex(n6), n2);
            }
        }
        n2 = this.copyData(nArray);
        if (n2 < 2) {
            n2 = this.naiveStates(n, nArray);
        }
        return n2;
    }

    private void initializeFields() {
        this.hap2Slots.clear();
        for (int i = 0; i < this.nStates; ++i) {
            this.slotHeap[i].hap = -1;
            this.slotHeap[i].end = -1;
            this.slotHeap[i].copyIndex = this.slotHeap[i].heapIndex;
            this.copyHaps[i].clear();
        }
    }

    private void updateFields(int n, int n2) {
        CopyHap copyHap = this.hap2Slots.get(n);
        if (copyHap != null) {
            copyHap.end = n2;
            PhaseStates.heapifyDown(this.slotHeap, copyHap.heapIndex);
        } else {
            int n3 = this.slotHeap[0].hap;
            int n4 = this.slotHeap[0].end;
            int n5 = this.slotHeap[0].copyIndex;
            if (n4 >= 0) {
                this.hap2Slots.remove(n3);
                this.copyHaps[n5].add(this.ibsHaps.stepStart(n4 + n2 >> 1));
            }
            this.copyHaps[n5].add(n);
            this.hap2Slots.put(n, this.slotHeap[0]);
            this.slotHeap[0].hap = n;
            this.slotHeap[0].end = n2;
            PhaseStates.heapifyDown(this.slotHeap, 0);
        }
    }

    private static void heapifyDown(CopyHap[] copyHapArray, int n) {
        CopyHap copyHap = copyHapArray[n];
        int n2 = 2 * n + 1;
        while (n2 < copyHapArray.length) {
            if (n2 + 1 < copyHapArray.length && copyHapArray[n2 + 1].end < copyHapArray[n2].end) {
                ++n2;
            }
            if (copyHapArray[n2].end >= copyHap.end) break;
            copyHapArray[n] = copyHapArray[n2];
            copyHapArray[n].heapIndex = n;
            n = n2;
            n2 = 2 * n + 1;
        }
        copyHapArray[n] = copyHap;
        copyHapArray[n].heapIndex = n;
    }

    private int copyData(int[][] nArray) {
        long l = System.nanoTime();
        PhaseData phaseData = this.ibsHaps.phaseData();
        int n = 0;
        for (int i = 0; i < this.nStates; ++i) {
            int n2 = 0;
            IntList intList = this.copyHaps[i];
            intList.add(phaseData.nMarkers());
            if (intList.size() <= 1) continue;
            int n3 = intList.size();
            for (int j = 0; j < n3; j += 2) {
                int n4 = intList.get(j);
                int n5 = intList.get(j + 1);
                for (int k = n2; k < n5; ++k) {
                    nArray[k][n] = phaseData.allele(k, n4);
                }
                n2 = n5;
            }
            ++n;
        }
        return n;
    }

    private int naiveStates(int n, int[][] nArray) {
        int n2;
        PhaseData phaseData = this.ibsHaps.phaseData();
        int n3 = phaseData.nMarkers();
        int n4 = phaseData.nHaps();
        int n5 = Math.min(this.nStates, n4 - 2);
        int n6 = 2 * n;
        int n7 = n2 = n6 + 1;
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            if (++n7 >= n4) {
                n7 -= n4;
            }
            if (n7 == n6 || n7 == n2) continue;
            for (int j = 0; j < n3; ++j) {
                nArray[j][n8] = phaseData.allele(j, n7);
            }
            ++n8;
        }
        return n8;
    }

    private static class CopyHap {
        private int hap = -1;
        private int end = -1;
        private int heapIndex;
        private int copyIndex;

        public CopyHap(int n) {
            this.heapIndex = n;
            this.copyIndex = n;
        }
    }
}

