/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.Utilities;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import math.Regress;
import phase.EstPhase;
import phase.PhaseBaum1;
import phase.PhaseData;
import phase.PhaseIbs;

public class PhaseLS {
    private PhaseLS() {
    }

    public static void run(PhaseData phaseData, EstPhase estPhase, Regress regress) {
        int n = phaseData.par().nthreads();
        int n2 = phaseData.nTargSamples();
        PhaseIbs phaseIbs = new PhaseIbs(phaseData);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        try {
            for (int i = 0; i < n; ++i) {
                PhaseBaum1 phaseBaum1 = new PhaseBaum1(phaseData, phaseIbs);
                executorService.submit(() -> {
                    try {
                        int n2 = atomicInteger.getAndIncrement();
                        while (n2 >= 0 && n2 < n2) {
                            phaseBaum1.phase(estPhase, n2, regress);
                            n2 = atomicInteger.getAndIncrement();
                        }
                    }
                    catch (Throwable throwable) {
                        Utilities.exit(throwable);
                    }
                });
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
    }
}

