/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import haplotype.HapPair;
import main.CurrentData;
import main.Par;
import phase.EstPhase;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGT;

public class PhaseData {
    private final CurrentData cd;
    private final int it;
    private final int nIts;
    private final boolean burnin;
    private final RefGT ref;
    private final HapPair[] targ;
    private final int nTargHaps;
    private final FloatArray pRecomb;
    private final double[] genPos;
    private final long seed;

    public PhaseData(CurrentData currentData, EstPhase estPhase, double d, int n, long l) {
        if (!currentData.targSamples().equals(estPhase.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (!currentData.targMarkers().equals(estPhase.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (d < 0.0 || !Double.isFinite(d)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        Par par = currentData.par();
        this.cd = currentData;
        this.it = n;
        this.nIts = par.burnin() + par.iterations();
        this.burnin = n < par.burnin();
        this.ref = currentData.restrictRefGT();
        this.targ = estPhase.getHapPairs().toArray(new HapPair[0]);
        this.nTargHaps = currentData.nTargHaps();
        this.genPos = currentData.map().genPos();
        this.pRecomb = PhaseData.pRecomb(currentData.genDist(), d);
        this.seed = l;
    }

    private static FloatArray pRecomb(FloatArray floatArray, double d) {
        float[] fArray = new float[floatArray.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(-Math.expm1(-d * (double)floatArray.get(i)));
        }
        return new FloatArray(fArray);
    }

    public Par par() {
        return this.cd.par();
    }

    public boolean burnin() {
        return this.burnin;
    }

    public int allele(int n, int n2) {
        if (n2 < this.nTargHaps) {
            HapPair hapPair = this.targ[n2 / 2];
            return (n2 & 1) == 0 ? hapPair.allele1(n) : hapPair.allele2(n);
        }
        return this.ref.allele(n, n2 - this.nTargHaps);
    }

    public int iter() {
        return this.it;
    }

    public int nItsRemaining() {
        return this.nIts - this.it;
    }

    public int nMarkers() {
        return this.cd.nTargMarkers();
    }

    public Markers markers() {
        return this.cd.targMarkers();
    }

    public Marker marker(int n) {
        return this.cd.targMarkers().marker(n);
    }

    public int nTargSamples() {
        return this.cd.nTargetSamples();
    }

    public int nRefHaps() {
        return this.cd.nRefHaps();
    }

    public int nTargHaps() {
        return this.cd.nTargHaps();
    }

    public int nHaps() {
        return this.cd.nHaps();
    }

    public float pErr(int n) {
        return this.cd.par().err();
    }

    public double[] genPos() {
        return (double[])this.genPos.clone();
    }

    public FloatArray genDist() {
        return this.cd.genDist();
    }

    public FloatArray pRecomb() {
        return this.pRecomb;
    }

    public long seed() {
        return this.seed;
    }
}

