/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.FileUtil;
import blbutil.Utilities;
import java.io.File;
import java.io.PrintWriter;
import main.Main;
import main.Par;
import main.Pedigree;
import vcf.Data;
import vcf.Marker;
import vcf.Markers;

public class RunStats {
    private final Par par;
    private final PrintWriter log;
    private final long startNanos = System.nanoTime();
    private long buildNanos = 0L;
    private long totalBuildNanos = 0L;
    private long totalIterationNanos = 0L;
    private long imputeNanos = 0L;
    private long totalImputeNanos = 0L;

    RunStats(Par par) {
        this.par = par;
        this.log = FileUtil.printWriter(new File(par.out() + ".log"));
    }

    public void printStartInfo() {
        String string;
        Utilities.duoPrint(this.log, Main.SHORT_HELP + Const.nl);
        Utilities.duoPrintln(this.log, "Start time: " + Utilities.timeStamp());
        Utilities.duoPrint(this.log, Utilities.commandLine("beagle.10Jun18.811.jar", this.par.args()));
        if (this.par.ped() != null) {
            string = Const.nl + "WARNING: This version will not model" + " duos or trios in the pedigree file";
            Utilities.duoPrintln(this.log, string);
        }
        if (this.par.map() == null) {
            string = Const.nl + "No genetic map is specified: using 1 cM = 1 Mb";
            Utilities.duoPrintln(this.log, string);
        }
        this.log.flush();
    }

    public void printSampleSummary(Data data) {
        Pedigree pedigree = data.ped();
        Utilities.duoPrint(this.log, Const.nl);
        Utilities.duoPrint(this.log, String.format("Reference samples: %,11d%n", data.nRefSamples()));
        Utilities.duoPrint(this.log, String.format("Study samples:     %,11d%n", data.nTargetSamples()));
        if (this.par.ped() != null) {
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nSingles()));
            Utilities.duoPrintln(this.log, " singles");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nDuos()));
            Utilities.duoPrintln(this.log, " duos");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nTrios()));
            Utilities.duoPrintln(this.log, " trios");
        }
        this.log.flush();
    }

    public void printWindowUpdate(Data data) {
        Markers markers = data.markers();
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.nMarkers() - 1);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(Const.nl);
        stringBuilder.append("Window ");
        stringBuilder.append(data.windowIndex());
        stringBuilder.append(" (");
        String string = marker.chrom();
        if (!string.equals(".")) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        stringBuilder.append(marker.pos());
        stringBuilder.append('-');
        if (!string.equals(marker2.chrom())) {
            stringBuilder.append(marker2.chrom());
            stringBuilder.append(':');
        }
        stringBuilder.append(marker2.pos());
        stringBuilder.append(')');
        stringBuilder.append(Const.nl);
        if (data.nRefSamples() > 0) {
            stringBuilder.append(String.format("Reference markers: %,11d%n", data.nMarkers()));
        }
        stringBuilder.append(String.format("Study markers:     %,11d%n", data.nTargetMarkers()));
        Utilities.duoPrint(this.log, stringBuilder.toString());
        this.log.flush();
    }

    public void printSummaryAndClose(int n, int n2) {
        long l = System.nanoTime() - this.startNanos;
        Utilities.duoPrint(this.log, Const.nl);
        Utilities.duoPrintln(this.log, "Cumulative Statistics:" + Const.nl);
        if (n != n2) {
            Utilities.duoPrint(this.log, String.format("Reference markers: %,11d%n", n2));
        }
        Utilities.duoPrint(this.log, String.format("Study markers:     %,11d%n%n", n));
        if (this.totalBuildNanos > 0L) {
            this.duoPrintNanos("Model building time:           ", this.totalBuildNanos);
        }
        if (this.totalIterationNanos > 1000L) {
            this.duoPrintNanos("Haplotype phasing time:        ", this.totalIterationNanos);
        }
        if (this.totalImputeNanos > 0L) {
            this.duoPrintNanos("Imputation time:               ", this.imputeNanos);
        }
        this.duoPrintNanos("Total time:                    ", l);
        Utilities.duoPrintln(this.log, Const.nl + "End time: " + Utilities.timeStamp());
        Utilities.duoPrintln(this.log, "beagle.10Jun18.811.jar finished");
        this.log.close();
    }

    public void buildNanos(long l) {
        this.buildNanos = l;
        this.totalBuildNanos += l;
    }

    public void iterationNanos(long l) {
        this.totalIterationNanos += l;
    }

    public void imputationNanos(long l) {
        this.imputeNanos = l;
        this.totalImputeNanos += l;
    }

    public void printImputationUpdate() {
        Utilities.duoPrint(this.log, Const.nl);
        this.duoPrintNanos("Imputation time:               ", this.imputeNanos);
        this.log.flush();
    }

    public void println(String string) {
        Utilities.duoPrintln(this.log, string);
        this.log.flush();
    }

    public void printIterationUpdate(int n, int n2) {
        Utilities.duoPrint(this.log, Const.nl + "Window=" + n + " Iteration=" + n2 + Const.nl);
        this.duoPrintNanos("Time for building model:         ", this.buildNanos);
        this.log.flush();
    }

    public void printPhasingIterationUpdate(int n, boolean bl, long l) {
        String string;
        this.iterationNanos(l);
        if (bl) {
            if (n == 1) {
                this.println("");
            }
            string = "Burnin  iteration " + n + ":";
        } else {
            if ((n -= this.par.burnin()) == 1) {
                this.println("");
            }
            string = "Phasing iteration " + n + ":";
        }
        this.duoPrintNanos(String.format("%1$-31s", string), l);
    }

    public void duoPrintNanos(String string, long l) {
        Utilities.duoPrint(this.log, string);
        Utilities.duoPrintln(this.log, Utilities.elapsedNanos(l));
    }
}

