/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.InputIt;
import blbutil.IntList;
import blbutil.StringUtil;
import java.io.File;
import java.util.Arrays;

public class Pedigree {
    private static final String NO_PAR = "0";
    private final Samples samples;
    private final int[] singles;
    private final int[] relateds;
    private final int[] duoOffspring;
    private final int[] trioOffspring;
    private final int[] mothers;
    private final int[] fathers;
    private final int[][] offspring;

    public Pedigree(Samples samples, File file) {
        int n = samples.nSamples();
        this.samples = samples;
        this.fathers = new int[n];
        this.mothers = new int[n];
        this.offspring = new int[n][];
        Arrays.fill(this.fathers, -1);
        Arrays.fill(this.mothers, -1);
        Arrays.fill((Object[])this.offspring, new int[0]);
        Pedigree.readPedFile(samples, file, this.fathers, this.mothers, this.offspring);
        int[] nArray = this.counts(this.fathers, this.mothers, this.offspring);
        this.singles = new int[nArray[0]];
        this.duoOffspring = new int[nArray[1]];
        this.trioOffspring = new int[nArray[2]];
        this.relateds = new int[n - nArray[0]];
        Pedigree.fillArrays(samples, this.fathers, this.mothers, this.offspring, this.singles, this.duoOffspring, this.trioOffspring, this.relateds);
    }

    private static void readPedFile(Samples samples, File file, int[] nArray, int[] nArray2, int[][] nArray3) {
        if (file != null) {
            boolean[] blArray = new boolean[samples.nSamples()];
            IntList[] intListArray = new IntList[samples.nSamples()];
            try (InputIt inputIt = InputIt.fromGzipFile(file);){
                while (inputIt.hasNext()) {
                    String string = ((String)inputIt.next()).trim();
                    Pedigree.readPedLine(samples, blArray, string, nArray, nArray2, intListArray);
                }
            }
            Pedigree.storeOffspring(intListArray, nArray3);
        }
    }

    private static void readPedLine(Samples samples, boolean[] blArray, String string, int[] nArray, int[] nArray2, IntList[] intListArray) {
        String[] stringArray;
        String string2;
        int n;
        if (string.length() > 0 && (n = samples.index(string2 = (stringArray = Pedigree.getPedFields(string))[1])) != -1) {
            Pedigree.markAsProcessed(blArray, n, string2);
            int n2 = stringArray[2].equals(NO_PAR) ? -1 : samples.index(stringArray[2]);
            int n3 = stringArray[3].equals(NO_PAR) ? -1 : samples.index(stringArray[3]);
            Pedigree.setParentOffspring(n2, n, nArray, intListArray);
            Pedigree.setParentOffspring(n3, n, nArray2, intListArray);
        }
    }

    private static String[] getPedFields(String string) {
        String[] stringArray = StringUtil.getFields(string, 5);
        if (stringArray.length < 4) {
            String string2 = "invalid line in ped file: " + string;
            throw new IllegalArgumentException(string2);
        }
        return stringArray;
    }

    private static void markAsProcessed(boolean[] blArray, int n, String string) {
        if (blArray[n]) {
            String string2 = "duplicate sample in pedigree file: " + string;
            throw new IllegalArgumentException(string2);
        }
        blArray[n] = true;
    }

    private static void setParentOffspring(int n, int n2, int[] nArray, IntList[] intListArray) {
        if (n != -1) {
            nArray[n2] = n;
            if (intListArray[n] == null) {
                intListArray[n] = new IntList(3);
            }
            intListArray[n].add(n2);
        }
    }

    private static void storeOffspring(IntList[] intListArray, int[][] nArray) {
        for (IntList intList : intListArray) {
            if (intList == null) continue;
            int[] nArray2 = intList.toArray();
            Arrays.sort(nArray2);
            nArray[var2_2] = nArray2;
        }
    }

    private int[] counts(int[] nArray, int[] nArray2, int[][] nArray3) {
        assert (nArray.length == nArray2.length);
        assert (nArray.length == nArray3.length);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < nArray3.length; ++i) {
            int n4 = Pedigree.nParents(i, nArray, nArray2);
            switch (n4) {
                case 0: {
                    if (nArray3[i].length != 0) continue block5;
                    ++n;
                    continue block5;
                }
                case 1: {
                    ++n2;
                    continue block5;
                }
                case 2: {
                    ++n3;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return new int[]{n, n2, n3};
    }

    private static void fillArrays(Samples samples, int[] nArray, int[] nArray2, int[][] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = samples.nSamples();
        block5: for (int i = 0; i < n5; ++i) {
            int n6 = Pedigree.nParents(i, nArray, nArray2);
            switch (n6) {
                case 0: {
                    if (nArray3[i].length == 0) {
                        nArray4[n++] = i;
                        continue block5;
                    }
                    nArray7[n4++] = i;
                    continue block5;
                }
                case 1: {
                    nArray5[n2++] = i;
                    nArray7[n4++] = i;
                    continue block5;
                }
                case 2: {
                    nArray6[n3++] = i;
                    nArray7[n4++] = i;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        assert (n == nArray4.length);
        assert (n2 == nArray5.length);
        assert (n3 == nArray6.length);
        assert (n4 == nArray7.length);
    }

    private static int nParents(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        if (nArray[n] >= 0) {
            ++n2;
        }
        if (nArray2[n] >= 0) {
            ++n2;
        }
        return n2;
    }

    public Samples samples() {
        return this.samples;
    }

    public int nSamples() {
        return this.samples.nSamples();
    }

    public int nSingles() {
        return this.singles.length;
    }

    public int nDuos() {
        return this.duoOffspring.length;
    }

    public int nTrios() {
        return this.trioOffspring.length;
    }

    public int[] singles() {
        return (int[])this.singles.clone();
    }

    public int[] relateds() {
        return (int[])this.relateds.clone();
    }

    public int single(int n) {
        return this.singles[n];
    }

    public int duoParent(int n) {
        int n2 = this.duoOffspring[n];
        if (this.fathers[n2] >= 0) {
            return this.fathers[n2];
        }
        assert (this.mothers[n2] >= 0);
        return this.mothers[n2];
    }

    public int duoOffspring(int n) {
        return this.duoOffspring[n];
    }

    public int trioFather(int n) {
        return this.fathers[this.trioOffspring[n]];
    }

    public int trioMother(int n) {
        return this.mothers[this.trioOffspring[n]];
    }

    public int trioOffspring(int n) {
        return this.trioOffspring[n];
    }

    public int father(int n) {
        return this.fathers[n];
    }

    public int mother(int n) {
        return this.mothers[n];
    }

    public int nOffspring(int n) {
        return this.offspring[n].length;
    }

    public int offspring(int n, int n2) {
        return this.offspring[n][n2];
    }

    public String toString() {
        return this.getClass().toString();
    }
}

