/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromInterval;
import blbutil.Const;
import blbutil.Validate;
import java.io.File;
import java.util.Map;

public final class Par {
    private final String[] args;
    private final File gt;
    private final File ref;
    private final String out;
    private final File ped;
    private final File map;
    private final ChromInterval chromInt;
    private final File excludesamples;
    private final File excludemarkers;
    private final int burnin;
    private final int iterations;
    private final int phase_states;
    private final float phase_segment;
    private final boolean impute;
    private final int imp_states;
    private final float imp_segment;
    private final float cluster;
    private final boolean ap;
    private final boolean gp;
    private final float ne;
    private final float err;
    private final float window;
    private final float overlap;
    private final long seed;
    private final int nthreads;
    private final float step;
    private final int nsteps;
    private final File truth;
    private static final int D_BURNIN = 6;
    private static final int D_ITERATIONS = 12;
    private static final int D_PHASE_STATES = 280;
    private static final float D_PHASE_SEGMENT = 4.0f;
    private static final boolean D_IMPUTE = true;
    private static final int D_IMP_STATES = 1600;
    private static final float D_IMP_SEGMENT = 6.0f;
    private static final float D_CLUSTER = 0.005f;
    private static final boolean D_AP = false;
    private static final boolean D_GP = false;
    private static final int D_NE = 1000000;
    private static final float D_ERR = 1.0E-4f;
    private static final float D_WINDOW = 40.0f;
    private static final float D_OVERLAP = 4.0f;
    private static final int D_SEED = -99999;
    private static final int D_NTHREADS = Integer.MAX_VALUE;
    private static final float D_STEP = 0.1f;
    private static final int D_NSTEPS = 7;

    public Par(String[] stringArray) {
        int n = Integer.MAX_VALUE;
        long l = Long.MIN_VALUE;
        long l2 = Long.MAX_VALUE;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        this.args = (String[])stringArray.clone();
        Map<String, String> map = Validate.argsToMap(stringArray, '=');
        this.gt = Validate.getFile(Validate.stringArg("gt", map, false, null, null));
        this.ref = Validate.getFile(Validate.stringArg("ref", map, false, null, null));
        this.out = Validate.stringArg("out", map, true, null, null);
        this.ped = Validate.getFile(Validate.stringArg("ped", map, false, null, null));
        this.map = Validate.getFile(Validate.stringArg("map", map, false, null, null));
        this.chromInt = Par.parseChromInt(Validate.stringArg("chrom", map, false, null, null));
        this.excludesamples = Validate.getFile(Validate.stringArg("excludesamples", map, false, null, null));
        this.excludemarkers = Validate.getFile(Validate.stringArg("excludemarkers", map, false, null, null));
        this.burnin = Validate.intArg("burnin", map, false, 6, 1, n);
        this.iterations = Validate.intArg("iterations", map, false, 12, 1, n);
        this.phase_states = Validate.intArg("phase-states", map, false, 280, 1, n);
        this.phase_segment = Validate.floatArg("phase-segment", map, false, 4.0f, f, f2);
        this.impute = Validate.booleanArg("impute", map, false, true);
        this.imp_states = Validate.intArg("imp-states", map, false, 1600, 1, n);
        this.imp_segment = Validate.floatArg("imp-segment", map, false, 6.0f, f, f2);
        this.cluster = Validate.floatArg("cluster", map, false, 0.005f, 0.0f, f2);
        this.ap = Validate.booleanArg("ap", map, false, false);
        this.gp = Validate.booleanArg("gp", map, false, false);
        this.ne = Validate.floatArg("ne", map, false, 1000000.0f, f, f2);
        this.err = Validate.floatArg("err", map, false, 1.0E-4f, 1.0E-10f, f2);
        this.window = Validate.floatArg("window", map, false, 40.0f, f, n);
        this.overlap = Validate.floatArg("overlap", map, false, 4.0f, f, n);
        this.seed = Validate.longArg("seed", map, false, -99999L, l, l2);
        this.nthreads = Par.modNthreads(Validate.intArg("nthreads", map, false, Integer.MAX_VALUE, 1, n));
        this.step = Validate.floatArg("step", map, false, 0.1f, f, f2);
        this.nsteps = Validate.intArg("nsteps", map, false, 7, 2, n);
        this.truth = Validate.getFile(Validate.stringArg("truth", map, false, null, null));
        Validate.confirmEmptyMap(map);
    }

    public String[] args() {
        return (String[])this.args.clone();
    }

    public static String usage() {
        String string = Const.nl;
        return "Usage: java -jar beagle.10Jun18.811.jar [arguments]" + string + string + "data parameters ..." + string + "  gt=<VCF file: use GT field>                        (optional)" + string + "  ref=<bref3 or VCF file with phased genotypes>      (optional)" + string + "  out=<output file prefix>                           (required)" + string + "  map=<PLINK map file with cM units>                 (optional)" + string + "  chrom=<[chrom] or [chrom]:[start]-[end]>           (optional)" + string + "  excludesamples=<file with 1 sample ID per line>    (optional)" + string + "  excludemarkers=<file with 1 marker ID per line>    (optional)" + string + string + "phasing parameters ..." + string + "  burnin=<number of burnin iterations>               (default=" + 6 + ")" + string + "  iterations=<number of phasing iterations>          (default=" + 12 + ")" + string + "  phase-states=<model states for phasing>            (default=" + 280 + ")" + string + "  phase-segment=<min haplotype segment length (cM)>  (default=" + 4.0f + ")" + string + string + "imputation parameters ..." + string + "  impute=<impute ungenotyped markers (true/false)>   (default=" + true + ")" + string + "  imp-states=<model states for imputation>           (default=" + 1600 + ")" + string + "  imp-segment=<min haplotype segment length (cM)>    (default=" + 6.0f + ")" + string + "  imp-cluster=<max cM in a marker cluster>           (default=" + 0.005f + ")" + string + "  imp-ap=<print posterior allele probabilities>      (default=" + false + ")" + string + "  imp-gp=<print posterior genotype probabilities>    (default=" + false + ")" + string + string + "general parameters ..." + string + "  ne=<effective population size>                     (default=" + 1000000 + ")" + string + "  err=<allele mismatch rate>                         (default=" + 1.0E-4f + ")" + string + "  window=<window length in cM>                       (default=" + 40.0f + ")" + string + "  overlap=<window overlap in cM>                     (default=" + 4.0f + ")" + string + "  seed=<random seed>                                 (default=" + -99999 + ")" + string + "  nthreads=<number of threads>                       (default: machine-dependent)" + string + "  step=<IBS step length (cM)>                        (default=" + 0.1f + ")" + string + "  nsteps=<number of IBS steps>                       (default=" + 7 + ")" + string + string;
    }

    private static ChromInterval parseChromInt(String string) {
        ChromInterval chromInterval = ChromInterval.parse(string);
        if (string != null && string.length() > 0 && chromInterval == null) {
            throw new IllegalArgumentException("Invalid chrom parameter: " + string);
        }
        return chromInterval;
    }

    private static int modNthreads(int n) {
        if (n == Integer.MAX_VALUE) {
            return Runtime.getRuntime().availableProcessors();
        }
        return n;
    }

    public File gt() {
        return this.gt;
    }

    public File ref() {
        return this.ref;
    }

    public String out() {
        return this.out;
    }

    public File ped() {
        return null;
    }

    public File map() {
        return this.map;
    }

    public ChromInterval chromInt() {
        return this.chromInt;
    }

    public File excludesamples() {
        return this.excludesamples;
    }

    public File excludemarkers() {
        return this.excludemarkers;
    }

    public int burnin() {
        return this.burnin;
    }

    public int iterations() {
        return this.iterations;
    }

    public int phase_states() {
        return this.phase_states;
    }

    public float phase_segment() {
        return this.phase_segment;
    }

    public boolean impute() {
        return this.impute;
    }

    public int imp_states() {
        return this.imp_states;
    }

    public float imp_segment() {
        return this.imp_segment;
    }

    public float cluster() {
        return this.cluster;
    }

    public boolean ap() {
        return this.ap;
    }

    public boolean gp() {
        return this.gp;
    }

    public float ne() {
        return this.ne;
    }

    public float err() {
        return this.err;
    }

    public float window() {
        return this.window;
    }

    public float overlap() {
        return this.overlap;
    }

    public long seed() {
        return this.seed;
    }

    public int nthreads() {
        return this.nthreads;
    }

    public float step() {
        return this.step;
    }

    public int nsteps() {
        return this.nsteps;
    }

    public File truth() {
        return this.truth;
    }
}

