/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.FloatArray;
import haplotype.HapPair;
import haplotype.HapPairPhasedGT;
import java.util.ArrayList;
import java.util.List;
import main.Par;
import main.Pedigree;
import vcf.Data;
import vcf.GT;
import vcf.GeneticMap;
import vcf.MarkerMap;
import vcf.Markers;
import vcf.PhasedGT;
import vcf.RefGT;
import vcf.SplicedGT;

public class CurrentData {
    private final Par par;
    private final int window;
    private final int prevSpliceStart;
    private final int nextOverlapStart;
    private final int nextSpliceStart;
    private final int prevTargSpliceStart;
    private final int nextTargetSpliceStart;
    private final int nextTargetOverlapStart;
    private final GT targGT;
    private final Pedigree ped;
    private final Samples refSamples;
    private final Samples targetSamples;
    private final Samples allSamples;
    private final int nHaps;
    private final Markers markers;
    private final Markers targetMarkers;
    private final int[] targMarkerIndex;
    private final int[] markerIndex;
    private final List<HapPair> restRefHapPairs;
    private final RefGT refGT;
    private final RefGT restrictRefGT;
    private final MarkerMap markerMap;
    private final FloatArray genDist;
    private final double intensity;

    public CurrentData(Par par, GeneticMap geneticMap, Data data, PhasedGT phasedGT) {
        if (phasedGT != null && !data.targetSamples().equals(phasedGT.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        double d = 0.04 * (double)par.ne() / (double)(2 * data.nAllSamples());
        this.par = par;
        this.window = data.windowIndex();
        this.prevSpliceStart = data.overlap() / 2;
        this.nextOverlapStart = data.nextOverlapStart();
        this.nextSpliceStart = data.nMarkers() + this.nextOverlapStart >>> 1;
        this.prevTargSpliceStart = phasedGT == null ? 0 : phasedGT.nMarkers();
        this.nextTargetOverlapStart = CurrentData.targetIndex(data, this.nextOverlapStart);
        this.nextTargetSpliceStart = CurrentData.targetIndex(data, this.nextSpliceStart);
        this.ped = data.ped();
        this.targGT = phasedGT == null ? data.targGT() : new SplicedGT(phasedGT, data.targGT());
        this.refSamples = data.refSamples();
        this.targetSamples = data.targetSamples();
        this.allSamples = data.allSamples();
        this.nHaps = 2 * this.allSamples.nSamples();
        this.markers = data.markers();
        this.targetMarkers = data.targetMarkers();
        this.targMarkerIndex = this.refToTargetMarker(data);
        this.markerIndex = CurrentData.targetToRefMarker(data);
        this.restRefHapPairs = data.restrictedRefHapPairs();
        this.refGT = data.refGT();
        this.restrictRefGT = data.restrictRefGT();
        this.markerMap = MarkerMap.create(geneticMap, data.targetMarkers());
        this.genDist = CurrentData.genDist(this.markerMap);
        this.intensity = d;
    }

    private static FloatArray genDist(MarkerMap markerMap) {
        float f = 1.0E-7f;
        float[] fArray = new float[markerMap.nMarkers()];
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = (float)(markerMap.genPos(i) - markerMap.genPos(i - 1));
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
        }
        return new FloatArray(fArray);
    }

    private static int nextOverlapStart(Data data, int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 0 || data.lastWindowOnChrom()) {
            return data.nMarkers();
        }
        Markers markers = data.markers();
        for (n2 = Math.max(0, data.nMarkers() - n); n2 > 0 && markers.marker(n2).pos() == markers.marker(n2 - 1).pos(); --n2) {
        }
        return n2;
    }

    private static int nextSpliceStart(Data data, int n) {
        if (data.canAdvanceWindow() && !data.lastWindowOnChrom()) {
            return data.nMarkers() - n + n / 2;
        }
        return data.nMarkers();
    }

    private static int targetIndex(Data data, int n) {
        int n2;
        for (n2 = 0; n2 < data.nTargetMarkers() && data.markerIndex(n2) < n; ++n2) {
        }
        return n2;
    }

    public Par par() {
        return this.par;
    }

    public int window() {
        return this.window;
    }

    public int nextOverlapStart() {
        return this.nextOverlapStart;
    }

    public int nextTargetOverlapStart() {
        return this.nextTargetOverlapStart;
    }

    public int prevSpliceStart() {
        return this.prevSpliceStart;
    }

    public int nextSpliceStart() {
        return this.nextSpliceStart;
    }

    public int prevTargetSpliceStart() {
        return this.prevTargSpliceStart;
    }

    public int nextTargetSpliceStart() {
        return this.nextTargetSpliceStart;
    }

    private int[] refToTargetMarker(Data data) {
        int[] nArray = new int[data.nMarkers()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = data.targetMarkerIndex(i);
        }
        return nArray;
    }

    private static int[] targetToRefMarker(Data data) {
        int[] nArray = new int[data.nTargetMarkers()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = data.markerIndex(i);
        }
        return nArray;
    }

    public Pedigree ped() {
        return this.ped;
    }

    public int nRefHaps() {
        return this.refGT == null ? 0 : this.refGT.nHaps();
    }

    public int nRefSamples() {
        return this.refSamples == null ? 0 : this.refSamples.nSamples();
    }

    public Samples refSamples() {
        return this.refSamples;
    }

    public int nTargHaps() {
        return this.targGT.nHaps();
    }

    public int nTargetSamples() {
        return this.targetSamples.nSamples();
    }

    public Samples targSamples() {
        return this.targetSamples;
    }

    public int nHaps() {
        return this.nHaps;
    }

    public int nAllSamples() {
        return this.allSamples.nSamples();
    }

    public Samples allSamples() {
        return this.allSamples;
    }

    public int nTargMarkers() {
        return this.targetMarkers.nMarkers();
    }

    public Markers targMarkers() {
        return this.targetMarkers;
    }

    public int nMarkers() {
        return this.markers.nMarkers();
    }

    public Markers markers() {
        return this.markers;
    }

    public int markerIndex(int n) {
        return this.markerIndex[n];
    }

    public int[] markerIndices() {
        return (int[])this.markerIndex.clone();
    }

    public int targMarkerIndex(int n) {
        return this.targMarkerIndex[n];
    }

    public int[] targMarkerIndices() {
        return (int[])this.targMarkerIndex.clone();
    }

    public void addRestrictedRefHapPairs(List<HapPair> list) {
        list.addAll(this.restRefHapPairs);
    }

    public RefGT refGT() {
        return this.refGT;
    }

    public RefGT restrictRefGT() {
        return this.restrictRefGT;
    }

    public GT targGT() {
        return this.targGT;
    }

    public float intensity() {
        return (float)this.intensity;
    }

    public MarkerMap map() {
        return this.markerMap;
    }

    public FloatArray genDist() {
        return this.genDist;
    }

    public PhasedGT allHapPairs(List<HapPair> list) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(list);
        this.addRestrictedRefHapPairs(arrayList);
        return new HapPairPhasedGT(this.allSamples, arrayList);
    }
}

