/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.IntList;
import blbutil.IntMap;
import imp.ImpData;
import imp.ImpIbs;

public final class ImpStates {
    private final ImpIbs ibsHaps;
    private final int nStates;
    private final IntMap<CopyHap> hap2Slots;
    private final CopyHap[] slotHeap;
    private final IntList[] copyHaps;

    public ImpStates(ImpIbs impIbs) {
        this.ibsHaps = impIbs;
        this.nStates = impIbs.nStates();
        this.hap2Slots = new IntMap(this.nStates);
        this.slotHeap = new CopyHap[this.nStates];
        this.copyHaps = new IntList[this.nStates];
        for (int i = 0; i < this.nStates; ++i) {
            this.slotHeap[i] = new CopyHap(i);
            this.copyHaps[i] = new IntList(10);
        }
    }

    public int nStates() {
        return this.nStates;
    }

    public int ibsStates(int n, int[][] nArray, boolean[][] blArray) {
        int n2;
        this.initializeFields();
        int n3 = this.ibsHaps.nSteps();
        for (n2 = 0; n2 < n3; ++n2) {
            int[] nArray2;
            for (int n4 : nArray2 = this.ibsHaps.ibsHaps(n, n2)) {
                this.updateFields(n4, n2);
            }
        }
        n2 = this.copyData(n, nArray, blArray);
        return n2;
    }

    private void initializeFields() {
        this.hap2Slots.clear();
        for (int i = 0; i < this.nStates; ++i) {
            this.slotHeap[i].hap = -1;
            this.slotHeap[i].end = -1;
            this.slotHeap[i].slotIndex = this.slotHeap[i].heapIndex;
            this.copyHaps[i].clear();
        }
    }

    private void updateFields(int n, int n2) {
        CopyHap copyHap = this.hap2Slots.get(n);
        if (copyHap != null) {
            copyHap.end = n2;
            ImpStates.heapifyDown(this.slotHeap, copyHap.heapIndex);
        } else {
            int n3 = this.slotHeap[0].hap;
            int n4 = this.slotHeap[0].end;
            int n5 = this.slotHeap[0].slotIndex;
            if (n4 >= 0) {
                this.hap2Slots.remove(n3);
                this.copyHaps[n5].add(this.ibsHaps.stepStart(n4 + n2 >>> 1));
            }
            this.copyHaps[n5].add(n);
            this.hap2Slots.put(n, this.slotHeap[0]);
            this.slotHeap[0].hap = n;
            this.slotHeap[0].end = n2;
            ImpStates.heapifyDown(this.slotHeap, 0);
        }
    }

    private static void heapifyDown(CopyHap[] copyHapArray, int n) {
        CopyHap copyHap = copyHapArray[n];
        int n2 = 2 * n + 1;
        while (n2 < copyHapArray.length) {
            if (n2 + 1 < copyHapArray.length && copyHapArray[n2 + 1].end < copyHapArray[n2].end) {
                ++n2;
            }
            if (copyHapArray[n2].end >= copyHap.end) break;
            copyHapArray[n] = copyHapArray[n2];
            copyHapArray[n].heapIndex = n;
            n = n2;
            n2 = 2 * n + 1;
        }
        copyHapArray[n] = copyHap;
        copyHapArray[n].heapIndex = n;
    }

    private int copyData(int n, int[][] nArray, boolean[][] blArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        ImpData impData = this.ibsHaps.impData();
        int n6 = 0;
        for (n5 = 0; n5 < this.nStates; ++n5) {
            n4 = 0;
            IntList intList = this.copyHaps[n5];
            intList.add(this.ibsHaps.impData().nClusters());
            if (intList.size() <= 1) continue;
            n3 = intList.size();
            for (n2 = 0; n2 < n3; n2 += 2) {
                int n7 = intList.get(n2);
                int n8 = intList.get(n2 + 1);
                for (int i = n4; i < n8; ++i) {
                    nArray[i][n6] = n7;
                }
                n4 = n8;
            }
            ++n6;
        }
        n5 = impData.nRefHaps() + n;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            int n9 = impData.allele(n4, n5);
            for (n2 = 0; n2 < n6; ++n2) {
                n3 = nArray[n4][n2];
                blArray[n4][n2] = impData.allele(n4, n3) == n9;
            }
        }
        return n6;
    }

    private static class CopyHap {
        private int hap = -1;
        private int end = -1;
        private int heapIndex;
        private int slotIndex;

        public CopyHap(int n) {
            this.heapIndex = n;
            this.slotIndex = n;
        }
    }
}

