/*
 * Decompiled with CFR 0.152.
 */
package bref;

import beagleutil.Samples;
import blbutil.IntArray;
import blbutil.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.SeqCodedRefGT;

public class SeqCoder3 {
    public static final int MAX_NALLELES = 255;
    public static final float COMPRESS_FREQ_THRESHOLD = 0.995f;
    private final Samples samples;
    private final int maxNSeq;
    private final List<RefGTRec> recs;
    private final int[] hap2Seq;
    private final IntList seq2Cnt;
    private final List<IntList> seq2AlleleMap;

    public SeqCoder3(Samples samples) {
        this(samples, SeqCoder3.defaultMaxNSeq(samples.nSamples()));
    }

    public SeqCoder3(Samples samples, int n) {
        if (n < 0 || n >= 65535) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.samples = samples;
        this.maxNSeq = n;
        this.recs = new ArrayList<RefGTRec>(100);
        this.hap2Seq = new int[2 * samples.nSamples()];
        this.seq2Cnt = new IntList(3 * n / 2 + 1);
        this.seq2AlleleMap = new ArrayList<IntList>(n + 1);
        this.initialize();
    }

    public static int defaultMaxNSeq(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 1) {
            return 3;
        }
        double d = 2.0 * Math.log10(n) + 1.0;
        long l = (long)Math.floor(Math.pow(2.0, d));
        if (l > 65535L) {
            return 65535;
        }
        return (int)l;
    }

    public Samples samples() {
        return this.samples;
    }

    public int nRecs() {
        return this.recs.size();
    }

    public int maxNSeq() {
        return this.maxNSeq;
    }

    public boolean add(RefGTRec refGTRec) {
        if (!refGTRec.samples().equals(this.samples)) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (!refGTRec.isAlleleCoded()) {
            throw new IllegalArgumentException(refGTRec.getClass().toString());
        }
        boolean bl = this.setAlleleMap(refGTRec);
        if (bl) {
            this.recs.add(refGTRec);
            int n = refGTRec.majorAllele();
            int n2 = refGTRec.nAlleles();
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                int n3 = refGTRec.alleleCount(i);
                for (int j = 0; j < n3; ++j) {
                    int n4;
                    int n5 = refGTRec.hapIndex(i, j);
                    int n6 = this.hap2Seq[n5];
                    IntList intList = this.seq2AlleleMap.get(n6);
                    for (n4 = 0; n4 < intList.size() && intList.get(n4) != i; n4 += 2) {
                    }
                    int n7 = intList.get(n4 + 1);
                    if (n7 == n6) continue;
                    while (n7 >= this.seq2Cnt.size()) {
                        this.seq2Cnt.add(0);
                    }
                    this.hap2Seq[n5] = n7;
                    this.seq2Cnt.decrementAndGet(n6);
                    this.seq2Cnt.incrementAndGet(n7);
                }
            }
        }
        assert (this.seq2Cnt.size() == this.seq2AlleleMap.size());
        return bl;
    }

    private void clearAlleleMap() {
        int n = this.seq2AlleleMap.size();
        for (int i = 0; i < n; ++i) {
            this.seq2AlleleMap.get(i).clear();
        }
    }

    private boolean setAlleleMap(RefGTRec refGTRec) {
        assert (this.seq2Cnt.size() == this.seq2AlleleMap.size());
        int n = this.seq2Cnt.size();
        int[] nArray = new int[n];
        this.clearAlleleMap();
        int n2 = refGTRec.nAlleles();
        int n3 = refGTRec.majorAllele();
        for (int i = 0; i < n2; ++i) {
            if (i == n3) continue;
            int n4 = refGTRec.alleleCount(i);
            for (int j = 0; j < n4; ++j) {
                int n5;
                int n6;
                int n7 = refGTRec.hapIndex(i, j);
                int n8 = n6 = this.hap2Seq[n7];
                nArray[n8] = nArray[n8] + 1;
                IntList intList = this.seq2AlleleMap.get(n6);
                if (intList.isEmpty()) {
                    intList.add(i);
                    intList.add(n6);
                    continue;
                }
                for (n5 = 0; n5 < intList.size() && intList.get(n5) != i; n5 += 2) {
                }
                if (n5 != intList.size()) continue;
                intList.add(i);
                intList.add(this.seq2AlleleMap.size());
                this.seq2AlleleMap.add(new IntList(4));
            }
        }
        this.addMajorAllele(nArray, n3);
        if (this.seq2AlleleMap.size() >= this.maxNSeq) {
            this.seq2AlleleMap.subList(n, this.seq2AlleleMap.size()).clear();
            return false;
        }
        return true;
    }

    private void addMajorAllele(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.seq2Cnt.get(i)) continue;
            IntList intList = this.seq2AlleleMap.get(i);
            if (intList.isEmpty()) {
                intList.add(n);
                intList.add(i);
                continue;
            }
            intList.add(intList.get(0));
            assert (intList.get(1) == i);
            intList.add(this.seq2AlleleMap.size());
            intList.set(0, n);
            this.seq2AlleleMap.add(new IntList(4));
        }
    }

    public List<RefGTRec> getCompressedList() {
        if (this.recs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RefGTRec> arrayList = new ArrayList<RefGTRec>(this.recs.size());
        int[] nArray = this.seq2Hap();
        IntArray intArray = IntArray.create(this.hap2Seq, 0, nArray.length);
        int n = this.recs.size();
        for (int i = 0; i < n; ++i) {
            RefGTRec refGTRec = this.recs.get(i);
            Marker marker = refGTRec.marker();
            IntArray intArray2 = this.seq2Allele(refGTRec, nArray);
            arrayList.add(new SeqCodedRefGT(marker, this.samples, intArray, intArray2));
        }
        this.initialize();
        return arrayList;
    }

    private int[] seq2Hap() {
        int[] nArray = new int[this.seq2AlleleMap.size()];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < this.hap2Seq.length; ++i) {
            int n = this.hap2Seq[i];
            if (nArray[n] != -1) continue;
            nArray[n] = i;
        }
        return nArray;
    }

    private IntArray seq2Allele(RefGTRec refGTRec, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = refGTRec.allele(nArray[i]);
        }
        return IntArray.create(nArray2, 0, refGTRec.nAlleles());
    }

    private void initialize() {
        this.recs.clear();
        this.seq2Cnt.clear();
        this.seq2AlleleMap.clear();
        Arrays.fill(this.hap2Seq, 0);
        this.seq2Cnt.add(this.hap2Seq.length);
        this.seq2AlleleMap.add(new IntList(4));
    }
}

