/*
 * Decompiled with CFR 0.152.
 */
package bref;

import beagleutil.Samples;
import blbutil.FileUtil;
import blbutil.Filter;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.Bref3Reader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import vcf.Marker;
import vcf.RefGTRec;

public final class Bref3It
implements SampleFileIt<RefGTRec> {
    private final File brefFile;
    private final DataInputStream bref;
    private final Bref3Reader bref3Reader;
    private final Deque<RefGTRec> buffer;

    public Bref3It(File file) {
        this(file, Filter.acceptAllFilter());
    }

    public Bref3It(File file, Filter<Marker> filter) {
        if (filter == null) {
            filter = Filter.acceptAllFilter();
        }
        InputStream inputStream = null;
        inputStream = file == null ? new BufferedInputStream(System.in) : FileUtil.bufferedInputStream(file);
        this.brefFile = file;
        this.bref = new DataInputStream(inputStream);
        this.bref3Reader = new Bref3Reader(this.bref, filter);
        this.buffer = new ArrayDeque<RefGTRec>(500);
        this.bref3Reader.readBlock(this.bref, this.buffer);
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty();
    }

    @Override
    public RefGTRec next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RefGTRec refGTRec = this.buffer.removeFirst();
        if (this.buffer.isEmpty()) {
            this.bref3Reader.readBlock(this.bref, this.buffer);
        }
        return refGTRec;
    }

    @Override
    public void close() {
        try {
            this.bref.close();
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing file", iOException);
        }
        this.buffer.clear();
    }

    @Override
    public File file() {
        return this.brefFile;
    }

    @Override
    public Samples samples() {
        return this.bref3Reader.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" : ");
        stringBuilder.append(this.brefFile);
        return stringBuilder.toString();
    }
}

