/*
 * Decompiled with CFR 0.152.
 */
package picard.util.IntervalList;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.List;
import picard.util.IntervalList.IntervalListScattererByBaseCount;

public class IntervalListScattererWithSubdivision
extends IntervalListScattererByBaseCount {
    @Override
    public IntervalList preprocessIntervalList(IntervalList inputList) {
        return inputList.uniqued();
    }

    @Override
    public List<Interval> takeSome(Interval interval, long idealSplitWeight, long currentSize, double projectSizeOfRemaining) {
        long amount = idealSplitWeight - currentSize;
        if (amount >= (long)interval.length()) {
            return CollectionUtil.makeList(interval, null);
        }
        if (amount == 0L) {
            return CollectionUtil.makeList(null, interval);
        }
        Interval left = new Interval(interval.getContig(), interval.getStart(), interval.getStart() + (int)amount - 1, interval.isNegativeStrand(), interval.getName());
        Interval right = new Interval(interval.getContig(), interval.getStart() + (int)amount, interval.getEnd(), interval.isNegativeStrand(), interval.getName());
        return CollectionUtil.makeList(left, right);
    }
}

