/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import picard.PicardException;
import picard.sam.markduplicates.UmiUtil;
import picard.util.GraphUtils;

public class UmiGraph {
    private final List<SAMRecord> records;
    private final Map<String, Long> umiCounts;
    private final int[] duplicateSetID;
    private final String[] umi;
    private final int numUmis;
    private final String umiTag;
    private final String molecularIdentifierTag;
    private final boolean allowMissingUmis;
    private final boolean duplexUmis;

    UmiGraph(DuplicateSet set, String umiTag, String molecularIdentifierTag, boolean allowMissingUmis, boolean duplexUmis) {
        this.umiTag = umiTag;
        this.molecularIdentifierTag = molecularIdentifierTag;
        this.allowMissingUmis = allowMissingUmis;
        this.duplexUmis = duplexUmis;
        this.records = set.getRecords();
        for (SAMRecord rec : this.records) {
            if (rec.getStringAttribute(umiTag) != null) continue;
            if (!allowMissingUmis) {
                throw new PicardException("Read " + rec.getReadName() + " does not contain a UMI with the " + umiTag + " attribute.");
            }
            rec.setAttribute(umiTag, (Object)"");
        }
        this.umiCounts = this.records.stream().collect(Collectors.groupingBy(p -> UmiUtil.getTopStrandNormalizedUmi(p, umiTag, duplexUmis), Collectors.counting()));
        this.numUmis = this.umiCounts.size();
        this.umi = new String[this.numUmis];
        this.duplicateSetID = IntStream.rangeClosed(0, this.numUmis - 1).toArray();
        int i = 0;
        Iterator<String> iterator = this.umiCounts.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            this.umi[i] = key = iterator.next();
            ++i;
        }
    }

    List<DuplicateSet> joinUmisIntoDuplicateSets(int maxEditDistanceToJoin) {
        GraphUtils.Graph<Integer> umiGraph = new GraphUtils.Graph<Integer>();
        for (int i = 0; i < this.numUmis; ++i) {
            umiGraph.addNode(i);
            for (int j = i + 1; j < this.numUmis; ++j) {
                if (!StringUtil.isWithinHammingDistance(this.umi[i], this.umi[j], maxEditDistanceToJoin)) continue;
                umiGraph.addEdge(i, j);
            }
        }
        Map umiClusterMap = umiGraph.cluster();
        for (int i = 0; i < this.numUmis; ++i) {
            this.duplicateSetID[i] = umiClusterMap.get(i);
        }
        HashMap duplicateSets = new HashMap();
        Map<String, Integer> duplicateSetsFromUmis = this.getDuplicateSetsFromUmis();
        for (SAMRecord rec : this.records) {
            String umi = UmiUtil.getTopStrandNormalizedUmi(rec, this.umiTag, this.duplexUmis);
            Integer duplicateSetIndex = duplicateSetsFromUmis.get(umi);
            if (duplicateSets.containsKey(duplicateSetIndex)) {
                ((List)duplicateSets.get(duplicateSetIndex)).add(rec);
                continue;
            }
            ArrayList<SAMRecord> n = new ArrayList<SAMRecord>();
            n.add(rec);
            duplicateSets.put(duplicateSetIndex, n);
        }
        ArrayList<DuplicateSet> duplicateSetList = new ArrayList<DuplicateSet>();
        for (Map.Entry entry : duplicateSets.entrySet()) {
            DuplicateSet ds = new DuplicateSet();
            List recordList = (List)entry.getValue();
            recordList.forEach(ds::add);
            long maxCount = 0L;
            String assignedUmi = null;
            String fewestNUmi = null;
            long nCount = 0L;
            for (SAMRecord rec : recordList) {
                String umi = UmiUtil.getTopStrandNormalizedUmi(rec, this.umiTag, this.duplexUmis);
                if (umi.contains("N")) {
                    int count = StringUtils.countMatches((CharSequence)umi, "N");
                    if (nCount == 0L) {
                        nCount = count;
                        fewestNUmi = umi;
                        continue;
                    }
                    if ((long)count >= nCount) continue;
                    nCount = count;
                    fewestNUmi = umi;
                    continue;
                }
                if (this.umiCounts.get(umi) <= maxCount) continue;
                maxCount = this.umiCounts.get(umi);
                assignedUmi = umi;
            }
            if (assignedUmi == null) {
                assignedUmi = fewestNUmi;
            }
            for (SAMRecord rec : recordList) {
                if (this.allowMissingUmis && rec.getStringAttribute(this.umiTag).isEmpty()) {
                    rec.setAttribute(this.umiTag, null);
                } else {
                    UmiUtil.setMolecularIdentifier(rec, assignedUmi, this.molecularIdentifierTag, this.duplexUmis);
                }
                rec.setTransientAttribute("inferredUmi", assignedUmi);
            }
            duplicateSetList.add(ds);
        }
        return duplicateSetList;
    }

    private Map<String, Integer> getDuplicateSetsFromUmis() {
        HashMap<String, Integer> duplicateSetsFromUmis = new HashMap<String, Integer>();
        for (int i = 0; i < this.duplicateSetID.length; ++i) {
            duplicateSetsFromUmis.put(this.umi[i], this.duplicateSetID[i]);
        }
        return duplicateSetsFromUmis;
    }
}

