/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(summary="Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads", oneLineSummary="Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class CleanSam
extends CommandLineProgram {
    static final String USAGE = "Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads";
    @Argument(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Argument(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] argv) {
        new CleanSam().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE);
        if (this.VALIDATION_STRINGENCY == ValidationStringency.STRICT) {
            factory.validationStringency(ValidationStringency.LENIENT);
        }
        SamReader reader = factory.open(this.INPUT);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
        SAMRecordIterator it = reader.iterator();
        ProgressLogger progress = new ProgressLogger(Log.getInstance(CleanSam.class));
        while (it.hasNext()) {
            SAMRecord rec = (SAMRecord)it.next();
            AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
            if (rec.getReadUnmappedFlag() && 0 != rec.getMappingQuality()) {
                rec.setMappingQuality(0);
            }
            writer.addAlignment(rec);
            progress.record(rec);
        }
        writer.close();
        it.close();
        CloserUtil.close(reader);
        return 0;
    }
}

