/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaMetricsCode;
import picard.illumina.parser.PerTilePerCycleFileUtil;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TilePhasingValue;
import picard.illumina.parser.TileTemplateRead;
import picard.illumina.parser.readers.EmpiricalPhasingMetricsOutReader;
import picard.illumina.parser.readers.TileMetricsOutReader;

public class TileMetricsUtil {
    private static final Log log = Log.getInstance(TileMetricsUtil.class);
    public static String INTEROP_SUBDIRECTORY_NAME = "InterOp";
    public static String TILE_METRICS_OUT_FILE_NAME = "TileMetricsOut.bin";
    private static final Log LOG = Log.getInstance(TileMetricsUtil.class);

    @Deprecated
    public static File renderTileMetricsFileFromBasecallingDirectory(File illuminaRunDirectory, int numCycles, boolean isNovaSeq) {
        return TileMetricsUtil.findTileMetricsFiles(illuminaRunDirectory, numCycles, isNovaSeq).get(0);
    }

    public static List<File> findTileMetricsFiles(File illuminaRunDirectory, int numCycles, boolean isNovaSeq) {
        List<File> files;
        Path interOpDir = illuminaRunDirectory.toPath().resolve(INTEROP_SUBDIRECTORY_NAME);
        ArrayList<Path> pathsToTest = new ArrayList<Path>();
        pathsToTest.add(interOpDir.resolve(TILE_METRICS_OUT_FILE_NAME));
        if (isNovaSeq) {
            for (int i = numCycles; i > 0; --i) {
                pathsToTest.add(interOpDir.resolve(String.format("C%d.1/%s", i, TILE_METRICS_OUT_FILE_NAME)));
            }
        }
        if ((files = pathsToTest.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList())).isEmpty()) {
            StringBuilder message = new StringBuilder(String.format("No %s file found in %s", INTEROP_SUBDIRECTORY_NAME, interOpDir));
            if (isNovaSeq) {
                message.append(" or any of its cycle directories.");
            }
            throw new IllegalStateException(message.toString());
        }
        return files;
    }

    private static Collection<Tile> getTileClusterRecordsV3(Map<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap, Map<Integer, Map<Integer, Collection<TilePhasingValue>>> phasingValues, float density) {
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        for (Map.Entry<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : locationToMetricsMap.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> tileRecords = entry.getValue();
            TileMetricsOutReader.IlluminaTileMetrics record = CollectionUtil.getSoleElement(tileRecords);
            if (!record.isClusterRecord()) continue;
            Collection<TilePhasingValue> tilePhasingValues = phasingValues.get(record.getLaneNumber()).get(record.getTileNumber());
            tiles.add(new Tile(record.getLaneNumber(), record.getTileNumber(), density, record.getMetricValue(), tilePhasingValues.toArray(new TilePhasingValue[tilePhasingValues.size()])));
        }
        return Collections.unmodifiableCollection(tiles);
    }

    public static Collection<Tile> parseClusterRecordsFromTileMetricsV3(Collection<File> tileMetricsOutFiles, Map<Integer, File> phasingMetricsFiles, ReadStructure readStructure) throws FileNotFoundException {
        Map<Integer, Map<Integer, Collection<TilePhasingValue>>> phasingValues = TileMetricsUtil.getTilePhasingValues(phasingMetricsFiles, readStructure);
        for (File tileMetricsOutFile : tileMetricsOutFiles) {
            TileMetricsOutReader tileMetricsIterator = new TileMetricsOutReader(tileMetricsOutFile, TileMetricsOutReader.TileMetricsVersion.THREE);
            float density = tileMetricsIterator.getDensity();
            Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics = TileMetricsUtil.determineLastValueForLaneTileMetricsCode(tileMetricsIterator);
            Map<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap = TileMetricsUtil.partitionTileMetricsByLocation(tileMetrics);
            Collection<Tile> tiles = TileMetricsUtil.getTileClusterRecordsV3(locationToMetricsMap, phasingValues, density);
            if (tiles.isEmpty()) continue;
            return tiles;
        }
        String pathsString = tileMetricsOutFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", "));
        throw new RuntimeException("None of the following input files contained cluster records: " + pathsString);
    }

    @Deprecated
    public static Collection<Tile> parseTileMetrics(File tileMetricsOutFile, Map<Integer, File> phasingMetricsFiles, ReadStructure readStructure, ValidationStringency validationStringency) throws FileNotFoundException {
        Map<Integer, Map<Integer, Collection<TilePhasingValue>>> phasingValues = TileMetricsUtil.getTilePhasingValues(phasingMetricsFiles, readStructure);
        TileMetricsOutReader tileMetricsIterator = new TileMetricsOutReader(tileMetricsOutFile, TileMetricsOutReader.TileMetricsVersion.THREE);
        Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics = TileMetricsUtil.determineLastValueForLaneTileMetricsCode(tileMetricsIterator);
        Map<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap = TileMetricsUtil.partitionTileMetricsByLocation(tileMetrics);
        return TileMetricsUtil.getTileClusterRecordsV3(locationToMetricsMap, phasingValues, tileMetricsIterator.getDensity());
    }

    public static Collection<Tile> parseTileMetrics(File tileMetricsOutFile, ReadStructure readStructure, ValidationStringency validationStringency) throws FileNotFoundException {
        Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics = TileMetricsUtil.determineLastValueForLaneTileMetricsCode(new TileMetricsOutReader(tileMetricsOutFile, TileMetricsOutReader.TileMetricsVersion.TWO));
        Map<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap = TileMetricsUtil.partitionTileMetricsByLocation(tileMetrics);
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        for (Map.Entry<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : locationToMetricsMap.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> tileRecords = entry.getValue();
            Map<Integer, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> codeMetricsMap = TileMetricsUtil.partitionTileMetricsByCode(tileRecords);
            Set<Integer> observedCodes = codeMetricsMap.keySet();
            if (!observedCodes.contains(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()) || !observedCodes.contains(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode())) {
                throw new PicardException(String.format("Expected to find cluster and density record codes (%s and %s) in records read for tile location %s (lane:tile), but found only %s.", IlluminaMetricsCode.CLUSTER_ID.getMetricsCode(), IlluminaMetricsCode.DENSITY_ID.getMetricsCode(), entry.getKey(), observedCodes));
            }
            TileMetricsOutReader.IlluminaTileMetrics densityRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()));
            TileMetricsOutReader.IlluminaTileMetrics clusterRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode()));
            Collection<TilePhasingValue> tilePhasingValues = TileMetricsUtil.getTilePhasingValues(codeMetricsMap, readStructure, validationStringency);
            tiles.add(new Tile(densityRecord.getLaneNumber(), densityRecord.getTileNumber(), densityRecord.getMetricValue(), clusterRecord.getMetricValue(), tilePhasingValues.toArray(new TilePhasingValue[tilePhasingValues.size()])));
        }
        return Collections.unmodifiableCollection(tiles);
    }

    private static Map<Integer, Map<Integer, Collection<TilePhasingValue>>> getTilePhasingValues(Map<Integer, File> phasingMetricFiles, ReadStructure readStructure) {
        HashMap<Integer, Map<Integer, Collection<TilePhasingValue>>> phasingValues = new HashMap<Integer, Map<Integer, Collection<TilePhasingValue>>>();
        int totalCycleCount = 0;
        boolean isFirstRead = true;
        int readNum = 0;
        for (int outputLength : readStructure.readLengths) {
            ReadDescriptor descriptor = readStructure.descriptors.get(readNum++);
            if (descriptor.type == ReadType.Template) {
                TileTemplateRead tileTemplateRead = isFirstRead ? TileTemplateRead.FIRST : TileTemplateRead.SECOND;
                ArrayList<Float> cycleNumWithData = new ArrayList<Float>();
                HashMap<Integer, Map> phasing = new HashMap<Integer, Map>();
                HashMap<Integer, Map> prePhasing = new HashMap<Integer, Map>();
                for (int cycle = 0; cycle < outputLength; ++cycle) {
                    File phasingData = phasingMetricFiles.get(totalCycleCount + 1);
                    if (phasingData != null) {
                        cycleNumWithData.add(Float.valueOf(cycle + 1));
                        EmpiricalPhasingMetricsOutReader reader = new EmpiricalPhasingMetricsOutReader(phasingData);
                        while (reader.hasNext()) {
                            EmpiricalPhasingMetricsOutReader.IlluminaPhasingMetrics phasingMetrics = reader.next();
                            TileMetricsOutReader.IlluminaLaneTileCode laneTileCode = phasingMetrics.laneTileCode;
                            int tileNumber = laneTileCode.getTileNumber();
                            int laneNumber = laneTileCode.getLaneNumber();
                            phasing.computeIfAbsent(tileNumber, k -> new HashMap()).computeIfAbsent(laneNumber, k -> new ArrayList()).add(Float.valueOf(phasingMetrics.phasingWeight));
                            prePhasing.computeIfAbsent(tileNumber, k -> new HashMap()).computeIfAbsent(laneNumber, k -> new ArrayList()).add(Float.valueOf(phasingMetrics.prephasingWeight));
                        }
                    }
                    ++totalCycleCount;
                }
                phasing.forEach((tileNum, lanePhasingMetrics) -> {
                    Map lanePrePhasingMetrics = (Map)prePhasing.get(tileNum);
                    lanePhasingMetrics.forEach((laneNum, phasingMetrics) -> {
                        List prephasingMetrics = (List)lanePrePhasingMetrics.get(laneNum);
                        float[] phasingSlopeAndOffset = TileMetricsUtil.computeLinearFit(cycleNumWithData.toArray(new Float[0]), phasingMetrics.toArray(new Float[0]), phasingMetrics.size());
                        float[] prePhasingSlopeAndOffset = TileMetricsUtil.computeLinearFit(cycleNumWithData.toArray(new Float[0]), prephasingMetrics.toArray(new Float[0]), phasingMetrics.size());
                        TilePhasingValue value = new TilePhasingValue(tileTemplateRead, phasingSlopeAndOffset[0], prePhasingSlopeAndOffset[0]);
                        phasingValues.computeIfAbsent((Integer)laneNum, k -> new HashMap()).computeIfAbsent(tileNum, k -> new ArrayList()).add(value);
                    });
                });
                isFirstRead = false;
                continue;
            }
            totalCycleCount += outputLength;
        }
        return phasingValues;
    }

    private static Collection<TilePhasingValue> getTilePhasingValues(Map<Integer, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> codeMetricsMap, ReadStructure readStructure, ValidationStringency validationStringency) {
        boolean isFirstRead = true;
        ArrayList<TilePhasingValue> tilePhasingValues = new ArrayList<TilePhasingValue>();
        for (int descriptorIndex = 0; descriptorIndex < readStructure.descriptors.size(); ++descriptorIndex) {
            float prePhasingValue;
            float phasingValue;
            if (readStructure.descriptors.get((int)descriptorIndex).type != ReadType.Template) continue;
            TileTemplateRead tileTemplateRead = isFirstRead ? TileTemplateRead.FIRST : TileTemplateRead.SECOND;
            int phasingCode = IlluminaMetricsCode.getPhasingCode(descriptorIndex, IlluminaMetricsCode.PHASING_BASE);
            int prePhasingCode = IlluminaMetricsCode.getPhasingCode(descriptorIndex, IlluminaMetricsCode.PREPHASING_BASE);
            if (codeMetricsMap.containsKey(phasingCode) && codeMetricsMap.containsKey(prePhasingCode)) {
                phasingValue = CollectionUtil.getSoleElement(codeMetricsMap.get(phasingCode)).getMetricValue();
                prePhasingValue = CollectionUtil.getSoleElement(codeMetricsMap.get(prePhasingCode)).getMetricValue();
            } else {
                String message = String.format("Don't have both phasing and prephasing values for %s read cycle %s.  Phasing code was %d and prephasing code was %d.", tileTemplateRead.toString(), descriptorIndex + 1, phasingCode, prePhasingCode);
                if (!codeMetricsMap.containsKey(phasingCode) && !codeMetricsMap.containsKey(prePhasingCode) && validationStringency != ValidationStringency.STRICT) {
                    if (validationStringency == ValidationStringency.LENIENT) {
                        LOG.warn(message);
                    }
                } else {
                    throw new PicardException(message);
                }
                phasingValue = 0.0f;
                prePhasingValue = 0.0f;
            }
            tilePhasingValues.add(new TilePhasingValue(tileTemplateRead, phasingValue, prePhasingValue));
            isFirstRead = false;
        }
        return tilePhasingValues;
    }

    private static Collection<TileMetricsOutReader.IlluminaTileMetrics> determineLastValueForLaneTileMetricsCode(Iterator<TileMetricsOutReader.IlluminaTileMetrics> tileMetricsIterator) {
        HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics> filteredTileMetrics = new HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics>();
        for (TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics : new IterableAdapter<TileMetricsOutReader.IlluminaTileMetrics>(tileMetricsIterator)) {
            filteredTileMetrics.put(illuminaTileMetrics.getLaneTileCode(), illuminaTileMetrics);
        }
        return filteredTileMetrics.values();
    }

    private static String renderMetricLocationKey(TileMetricsOutReader.IlluminaTileMetrics metric) {
        return String.format("%s:%s", metric.getLaneNumber(), metric.getTileNumber());
    }

    private static Map<Integer, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByCode(Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics) {
        return tileMetrics.stream().collect(Collectors.groupingBy(TileMetricsOutReader.IlluminaTileMetrics::getMetricCode));
    }

    private static Map<String, ? extends Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByLocation(Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics) {
        return tileMetrics.stream().collect(Collectors.groupingBy(TileMetricsUtil::renderMetricLocationKey));
    }

    public static Map<Integer, File> renderPhasingMetricsFilesFromBasecallingDirectory(File illuminaRunDirectory) {
        File[] cycleDirs = IOUtil.getFilesMatchingRegexp(new File(illuminaRunDirectory, INTEROP_SUBDIRECTORY_NAME), IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN);
        HashMap<Integer, File> phasingMetrics = new HashMap<Integer, File>();
        Arrays.asList(cycleDirs).forEach(cycleDir -> {
            File[] filesMatchingRegexp = IOUtil.getFilesMatchingRegexp(cycleDir, "EmpiricalPhasingMetricsOut.bin");
            if (filesMatchingRegexp.length > 0) {
                phasingMetrics.put(PerTilePerCycleFileUtil.getCycleFromDir(cycleDir), filesMatchingRegexp[0]);
            }
        });
        return phasingMetrics;
    }

    private static float[] computeLinearFit(Float[] xValues, Float[] yValues, int sampleCount) {
        if (sampleCount == 0 || sampleCount > xValues.length) {
            sampleCount = xValues.length;
        }
        if (xValues.length <= 1 || xValues.length != yValues.length) {
            throw new PicardException("Can not compute linear fit.");
        }
        float sumX = 0.0f;
        float sumY = 0.0f;
        float sumXX = 0.0f;
        float sumXY = 0.0f;
        float slope = 0.0f;
        float offset = 0.0f;
        for (int i = 0; i < sampleCount; ++i) {
            sumX += xValues[i].floatValue();
            sumY += yValues[i].floatValue();
            sumXY += xValues[i].floatValue() * yValues[i].floatValue();
            sumXX += xValues[i].floatValue() * xValues[i].floatValue();
        }
        float denominator = (float)sampleCount * sumXX - sumX * sumX;
        if (denominator > Math.ulp(denominator)) {
            slope = ((float)sampleCount * sumXY - sumX * sumY) / denominator;
            offset = (sumY * sumXX - sumX * sumXY) / denominator;
        }
        return new float[]{slope, offset};
    }
}

