/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import picard.illumina.parser.BclData;
import picard.illumina.parser.BclParser;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PerTileCycleParser;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.illumina.parser.readers.BclReader;

public class MultiTileBclParser
extends BclParser {
    private final TileIndex tileIndex;
    private MultiTileBclDataCycleFileParser cycleFileParser = null;

    public MultiTileBclParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping, boolean applyEamssFilter, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, TileIndex tileIndex) {
        super(directory, lane, tilesToCycleFiles, outputMapping, applyEamssFilter, bclQualityEvaluationStrategy);
        this.tileIndex = tileIndex;
        this.initialize();
    }

    @Override
    public void initialize() {
        if (this.tileIndex != null) {
            this.seekToTile(this.currentTile);
        }
    }

    private CountLimitedIterator makeReader(List<File> files) {
        if (this.tileIndex != null) {
            BclReader bclReader = BclReader.makeSeekable(files, this.bclQualityEvaluationStrategy, this.outputMapping.getOutputReadLengths());
            int numClustersInTile = bclReader.seek(files, this.tileIndex, this.currentTile);
            return new CountLimitedIterator(bclReader, numClustersInTile);
        }
        return null;
    }

    @Override
    protected PerTileCycleParser.CycleFilesParser<BclData> makeCycleFileParser(List<File> files, PerTileCycleParser.CycleFilesParser<BclData> cycleFilesParser) {
        return this.makeCycleFileParser(files);
    }

    @Override
    protected PerTileCycleParser.CycleFilesParser<BclData> makeCycleFileParser(List<File> files) {
        if (this.cycleFileParser == null) {
            this.cycleFileParser = new MultiTileBclDataCycleFileParser(files, this.currentTile);
        } else {
            int numClustersInTile = this.cycleFileParser.getReader().seek(files, this.tileIndex, this.currentTile);
            this.cycleFileParser.setCurrentTile(this.currentTile);
            this.cycleFileParser.resetClusterLimit(numClustersInTile);
        }
        return this.cycleFileParser;
    }

    private class MultiTileBclDataCycleFileParser
    implements PerTileCycleParser.CycleFilesParser<BclData> {
        final CountLimitedIterator reader;
        int currentTile;

        public MultiTileBclDataCycleFileParser(List<File> files, int currentTile) {
            this.currentTile = currentTile;
            this.reader = MultiTileBclParser.this.makeReader(files);
        }

        @Override
        public void close() {
            this.reader.close();
        }

        @Override
        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.reader.next();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (NullPointerException npe) {
                return false;
            }
        }

        public int getCurrentTile() {
            return this.currentTile;
        }

        public BclReader getReader() {
            return this.reader.getUnderlyingIterator();
        }

        public void resetClusterLimit(int numClustersInTile) {
            this.reader.recordLimit = numClustersInTile;
            this.reader.numRecordsRead = 0;
        }

        public void setCurrentTile(int currentTile) {
            this.currentTile = currentTile;
        }
    }

    static class CountLimitedIterator
    implements CloseableIterator<BclData> {
        private final BclReader underlyingIterator;
        private int recordLimit;
        private int numRecordsRead = 0;

        public BclReader getUnderlyingIterator() {
            return this.underlyingIterator;
        }

        CountLimitedIterator(BclReader underlyingIterator, int recordLimit) {
            this.underlyingIterator = underlyingIterator;
            this.recordLimit = recordLimit;
        }

        @Override
        public void close() {
            this.underlyingIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.numRecordsRead < this.recordLimit && this.underlyingIterator.hasNext();
        }

        @Override
        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.numRecordsRead;
            return this.underlyingIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

