/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import java.util.ArrayList;
import java.util.Collection;
import picard.illumina.LanePhasingMetricsCollector;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileTemplateRead;

public class IlluminaPhasingMetrics
extends MetricBase {
    public long LANE;
    public String TYPE_NAME;
    public double PHASING_APPLIED;
    public double PREPHASING_APPLIED;

    public static Collection<IlluminaPhasingMetrics> getPhasingMetricsForTiles(long lane, Collection<Tile> tilesForLane, boolean usePercentage) {
        LanePhasingMetricsCollector lanePhasingMetricsCollector = new LanePhasingMetricsCollector(tilesForLane, usePercentage);
        ArrayList<IlluminaPhasingMetrics> phasingMetrics = new ArrayList<IlluminaPhasingMetrics>();
        for (TileTemplateRead tileTemplateRead : lanePhasingMetricsCollector.getMedianPhasingMap().keySet()) {
            IlluminaPhasingMetrics phasingMetric = new IlluminaPhasingMetrics();
            phasingMetric.LANE = lane;
            phasingMetric.TYPE_NAME = tileTemplateRead.toString();
            phasingMetric.PHASING_APPLIED = lanePhasingMetricsCollector.getMedianPhasingMap().get((Object)tileTemplateRead).floatValue();
            phasingMetric.PREPHASING_APPLIED = lanePhasingMetricsCollector.getMedianPrePhasingMap().get((Object)tileTemplateRead).floatValue();
            phasingMetrics.add(phasingMetric);
        }
        return phasingMetrics;
    }

    public static String getExtension() {
        return "illumina_phasing_metrics";
    }
}

