/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;

public class Snp
implements Comparable<Snp> {
    private final String name;
    private final String chrom;
    private final int pos;
    private final byte allele1;
    private final byte allele2;
    private final double maf;
    private final List<String> fingerprintPanels;
    private final DiploidGenotype[] genotypes = new DiploidGenotype[3];

    public Snp(String name, String chrom, int pos, byte allele1, byte allele2, double maf, List<String> fingerprintPanels) {
        this.name = name;
        this.chrom = chrom;
        this.pos = pos;
        this.allele1 = StringUtil.toUpperCase(allele1);
        this.allele2 = StringUtil.toUpperCase(allele2);
        this.maf = maf;
        this.fingerprintPanels = fingerprintPanels == null ? new ArrayList() : fingerprintPanels;
        this.genotypes[0] = DiploidGenotype.fromBases(allele1, allele1);
        this.genotypes[1] = DiploidGenotype.fromBases(allele1, allele2);
        this.genotypes[2] = DiploidGenotype.fromBases(allele2, allele2);
    }

    public Snp flip() {
        return new Snp(this.name, this.chrom, this.pos, this.allele2, this.allele1, 1.0 - this.maf, this.fingerprintPanels);
    }

    public String getName() {
        return this.name;
    }

    public String getChrom() {
        return this.chrom;
    }

    public int getPos() {
        return this.pos;
    }

    public byte getAllele1() {
        return this.allele1;
    }

    public byte getAllele2() {
        return this.allele2;
    }

    public double getMaf() {
        return this.maf;
    }

    public List<String> getFingerprintPanels() {
        return this.fingerprintPanels;
    }

    public DiploidGenotype getHomozygousAllele1Genotype() {
        return this.genotypes[0];
    }

    public DiploidGenotype getHeterogyzousGenotype() {
        return this.genotypes[1];
    }

    public DiploidGenotype getHomozygousAllele2Genotype() {
        return this.genotypes[2];
    }

    DiploidGenotype getGenotype(DiploidHaplotype haplotype) {
        return this.genotypes[haplotype.ordinal()];
    }

    int indexOf(DiploidGenotype gt) {
        for (int i = 0; i < this.genotypes.length; ++i) {
            if (gt != this.genotypes[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Genotype " + (Object)((Object)gt) + " is not valid for this SNP.");
    }

    public String getAlleleString() {
        return StringUtil.bytesToString(new byte[]{this.allele1, StringUtil.toLowerCase(this.allele2)});
    }

    @Override
    public int compareTo(Snp that) {
        int retval = this.chrom.compareTo(that.chrom);
        if (retval == 0) {
            retval = this.pos - that.pos;
        }
        return retval;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Snp && this.compareTo((Snp)o) == 0;
    }

    public int hashCode() {
        int result = this.chrom.hashCode();
        result = 31 * result + this.pos;
        return result;
    }

    public String toString() {
        return this.chrom + ":" + this.pos;
    }
}

