/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;

public class BashTabCompletionDoclet
extends HelpDoclet {
    private static final String CALLER_SCRIPT_NAME = "-caller-script-name";
    private static final String CALLER_SCRIPT_PREFIX_LEGAL_ARGS = "-caller-pre-legal-args";
    private static final String CALLER_SCRIPT_PREFIX_ARG_VALUE_TYPES = "-caller-pre-arg-val-types";
    private static final String CALLER_SCRIPT_PREFIX_MUTEX_ARGS = "-caller-pre-mutex-args";
    private static final String CALLER_SCRIPT_PREFIX_ALIAS_ARGS = "-caller-pre-alias-args";
    private static final String CALLER_SCRIPT_PREFIX_ARG_MIN_OCCURRENCES = "-caller-pre-arg-min-occurs";
    private static final String CALLER_SCRIPT_PREFIX_ARG_MAX_OCCURRENCES = "-caller-pre-arg-max-occurs";
    private static final String CALLER_SCRIPT_POSTFIX_LEGAL_ARGS = "-caller-post-legal-args";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_VALUE_TYPES = "-caller-post-arg-val-types";
    private static final String CALLER_SCRIPT_POSTFIX_MUTEX_ARGS = "-caller-post-mutex-args";
    private static final String CALLER_SCRIPT_POSTFIX_ALIAS_ARGS = "-caller-post-alias-args";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_MIN_OCCURRENCES = "-caller-post-arg-min-occurs";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_MAX_OCCURRENCES = "-caller-post-arg-max-occurs";
    private String callerScriptName = null;
    private String callerScriptPrefixLegalArgs = "";
    private String callerScriptPrefixArgValueTypes = "";
    private String callerScriptPrefixMutexArgs = "";
    private String callerScriptPrefixAliasArgs = "";
    private String callerScriptPrefixMinOccurrences = "";
    private String callerScriptPrefixMaxOccurrences = "";
    private String callerScriptPostfixLegalArgs = "";
    private String callerScriptPostfixArgValueTypes = "";
    private String callerScriptPostfixMutexArgs = "";
    private String callerScriptPostfixAliasArgs = "";
    private String callerScriptPostfixMinOccurrences = "";
    private String callerScriptPostfixMaxOccurrences = "";
    private boolean hasCallerScriptPostfixArgs = false;
    protected static String outputFileExtension = "sh";
    protected static String indexFileExtension = "sh";

    public static boolean start(RootDoc rootDoc) {
        try {
            return new BashTabCompletionDoclet().startProcessDocs(rootDoc);
        }
        catch (IOException e) {
            throw new DocException("Exception processing javadoc", e);
        }
    }

    private String quoteEachWord(String sentence) {
        return this.quoteEachWord(sentence, " ");
    }

    private String quoteEachWord(String sentence, String sep) {
        return Stream.of(sentence.split(sep)).map(s -> String.format("\"%s\"", s)).collect(Collectors.joining(sep));
    }

    public static int optionLength(String option) {
        if (option.equals(CALLER_SCRIPT_NAME) || option.equals(CALLER_SCRIPT_PREFIX_LEGAL_ARGS) || option.equals(CALLER_SCRIPT_PREFIX_ARG_VALUE_TYPES) || option.equals(CALLER_SCRIPT_PREFIX_MUTEX_ARGS) || option.equals(CALLER_SCRIPT_PREFIX_ALIAS_ARGS) || option.equals(CALLER_SCRIPT_PREFIX_ARG_MIN_OCCURRENCES) || option.equals(CALLER_SCRIPT_PREFIX_ARG_MAX_OCCURRENCES) || option.equals(CALLER_SCRIPT_POSTFIX_LEGAL_ARGS) || option.equals(CALLER_SCRIPT_POSTFIX_ARG_VALUE_TYPES) || option.equals(CALLER_SCRIPT_POSTFIX_MUTEX_ARGS) || option.equals(CALLER_SCRIPT_POSTFIX_ALIAS_ARGS) || option.equals(CALLER_SCRIPT_POSTFIX_ARG_MIN_OCCURRENCES) || option.equals(CALLER_SCRIPT_POSTFIX_ARG_MAX_OCCURRENCES)) {
            return 2;
        }
        return HelpDoclet.optionLength(option);
    }

    @Override
    protected void validateDocletStartingState() {
        if (this.callerScriptName == null) {
            throw new RuntimeException("ERROR: You must specify a caller script name using the option: -caller-script-name");
        }
    }

    @Override
    protected boolean parseOption(String[] option) {
        boolean hasParsedOption = super.parseOption(option);
        if (!hasParsedOption) {
            if (option[0].equals(CALLER_SCRIPT_NAME)) {
                int lastDotIndex = option[1].lastIndexOf(46);
                this.callerScriptName = lastDotIndex != -1 ? option[1].substring(0, lastDotIndex) : option[1];
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_LEGAL_ARGS)) {
                this.callerScriptPrefixLegalArgs = option[1];
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_ARG_VALUE_TYPES)) {
                this.callerScriptPrefixArgValueTypes = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_MUTEX_ARGS)) {
                this.callerScriptPrefixMutexArgs = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_ALIAS_ARGS)) {
                this.callerScriptPrefixAliasArgs = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_ARG_MIN_OCCURRENCES)) {
                this.callerScriptPrefixMinOccurrences = option[1];
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_PREFIX_ARG_MAX_OCCURRENCES)) {
                this.callerScriptPrefixMaxOccurrences = option[1];
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_LEGAL_ARGS)) {
                this.callerScriptPostfixLegalArgs = option[1];
                this.hasCallerScriptPostfixArgs = !this.callerScriptPostfixLegalArgs.isEmpty();
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_ARG_VALUE_TYPES)) {
                this.callerScriptPostfixArgValueTypes = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_MUTEX_ARGS)) {
                this.callerScriptPostfixMutexArgs = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_ALIAS_ARGS)) {
                this.callerScriptPostfixAliasArgs = this.quoteEachWord(option[1]);
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_ARG_MIN_OCCURRENCES)) {
                this.callerScriptPostfixMinOccurrences = option[1];
                hasParsedOption = true;
            } else if (option[0].equals(CALLER_SCRIPT_POSTFIX_ARG_MAX_OCCURRENCES)) {
                this.callerScriptPostfixMaxOccurrences = option[1];
                hasParsedOption = true;
            }
        }
        return hasParsedOption;
    }

    @Override
    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
    }

    @Override
    protected void processIndexTemplate(Configuration cfg, List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) throws IOException {
        HashMap propertiesMap = new HashMap();
        this.workUnits.stream().forEach(workUnit -> propertiesMap.put(workUnit.getName(), workUnit.getRootMap()));
        HashMap rootMap = new HashMap();
        rootMap.put("tools", propertiesMap);
        HashMap<String, String> callerScriptOptionsMap = new HashMap<String, String>();
        callerScriptOptionsMap.put("callerScriptName", this.callerScriptName);
        callerScriptOptionsMap.put("callerScriptPrefixLegalArgs", this.callerScriptPrefixLegalArgs);
        callerScriptOptionsMap.put("callerScriptPrefixArgValueTypes", this.callerScriptPrefixArgValueTypes);
        callerScriptOptionsMap.put("callerScriptPrefixMutexArgs", this.callerScriptPrefixMutexArgs);
        callerScriptOptionsMap.put("callerScriptPrefixAliasArgs", this.callerScriptPrefixAliasArgs);
        callerScriptOptionsMap.put("callerScriptPrefixMinOccurrences", this.callerScriptPrefixMinOccurrences);
        callerScriptOptionsMap.put("callerScriptPrefixMaxOccurrences", this.callerScriptPrefixMaxOccurrences);
        callerScriptOptionsMap.put("callerScriptPostfixLegalArgs", this.callerScriptPostfixLegalArgs);
        callerScriptOptionsMap.put("callerScriptPostfixArgValueTypes", this.callerScriptPostfixArgValueTypes);
        callerScriptOptionsMap.put("callerScriptPostfixMutexArgs", this.callerScriptPostfixMutexArgs);
        callerScriptOptionsMap.put("callerScriptPostfixAliasArgs", this.callerScriptPostfixAliasArgs);
        callerScriptOptionsMap.put("callerScriptPostfixMinOccurrences", this.callerScriptPostfixMinOccurrences);
        callerScriptOptionsMap.put("callerScriptPostfixMaxOccurrences", this.callerScriptPostfixMaxOccurrences);
        if (this.hasCallerScriptPostfixArgs) {
            callerScriptOptionsMap.put("hasCallerScriptPostfixArgs", "true");
        } else {
            callerScriptOptionsMap.put("hasCallerScriptPostfixArgs", "false");
        }
        rootMap.put("callerScriptOptions", callerScriptOptionsMap);
        Template template = cfg.getTemplate(this.getIndexTemplateName());
        File indexFile = new File(this.getDestinationDir(), this.getIndexBaseFileName() + "." + this.getIndexFileExtension());
        try (FileOutputStream fileOutStream = new FileOutputStream(indexFile);
             OutputStreamWriter outWriter = new OutputStreamWriter(fileOutStream);){
            template.process(rootMap, outWriter);
        }
        catch (TemplateException e) {
            throw new DocException("Freemarker Template Exception during documentation index creation", e);
        }
    }

    @Override
    public String getIndexTemplateName() {
        return "bash-completion.ftl";
    }

    @Override
    public String getIndexBaseFileName() {
        return this.callerScriptName + "-completion";
    }
}

