/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;

public interface CommandLineParser {
    public boolean parseArguments(PrintStream var1, String[] var2);

    public String getCommandLine();

    public String getStandardUsagePreamble(Class<?> var1);

    public String getVersion();

    default public <T> T getPluginDescriptor(Class<T> targetDescriptor) {
        throw new CommandLineException.CommandLineParserInternalException("Command line plugins are not implemented by this command line parser");
    }

    public String usage(boolean var1, boolean var2);

    public static <T> List<Pair<Field, T>> gatherArgumentValuesOfType(Class<T> type, Object argumentSource) {
        ArrayList<Pair<Field, T>> argumentValues = new ArrayList<Pair<Field, T>>();
        for (Field field : CommandLineParser.getAllFields(argumentSource.getClass())) {
            field.setAccessible(true);
            try {
                if (field.getAnnotation(Argument.class) != null && type.isAssignableFrom(CommandLineParser.getUnderlyingType(field))) {
                    if (CommandLineParser.isCollectionField(field)) {
                        Collection argumentContainer = (Collection)field.get(argumentSource);
                        if (argumentContainer.isEmpty()) {
                            argumentValues.add(Pair.of(field, null));
                            continue;
                        }
                        for (Object argumentValue : argumentContainer) {
                            argumentValues.add(Pair.of(field, type.cast(argumentValue)));
                        }
                        continue;
                    }
                    argumentValues.add(Pair.of(field, type.cast(field.get(argumentSource))));
                    continue;
                }
                if (field.getAnnotation(ArgumentCollection.class) == null) continue;
                argumentValues.addAll(CommandLineParser.gatherArgumentValuesOfType(type, field.get(argumentSource)));
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("field access failed after setAccessible(true)");
            }
        }
        return argumentValues;
    }

    public static Class<?> getUnderlyingType(Field field) {
        if (CommandLineParser.isCollectionField(field)) {
            ParameterizedType clazz = (ParameterizedType)field.getGenericType();
            Type[] genericTypes = clazz.getActualTypeArguments();
            if (genericTypes.length != 1) {
                throw new CommandLineException.CommandLineParserInternalException("Strange collection type for field " + field.getName());
            }
            return (Class)(genericTypes[0] instanceof ParameterizedType ? ((ParameterizedType)genericTypes[0]).getRawType() : genericTypes[0]);
        }
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> ret = new ArrayList<Field>();
        do {
            ret.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return ret;
    }

    public static boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static interface ClpEnum {
        public String getHelpDoc();
    }
}

