/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClassFinder {
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final ClassLoader loader;
    private Class<?> parentType;
    private String jarPath = null;
    private static final Logger log = LogManager.getLogger();

    public ClassFinder() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public ClassFinder(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassFinder(File jarFile) throws IOException {
        this.jarPath = jarFile.getCanonicalPath();
        URL[] urls = new URL[]{new URL("file", "", this.jarPath)};
        this.loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public String toClassName(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public void find(String packageName, Class<?> parentType) {
        Enumeration<URL> urls;
        this.parentType = parentType;
        packageName = packageName.replace('.', '/');
        try {
            urls = this.loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.warn("Could not read package: " + packageName, (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (this.jarPath != null && !this.jarPath.equals(urlPath)) continue;
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.scanDir(file, packageName);
                    continue;
                }
                this.scanJar(file, packageName);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", (Throwable)ioe);
            }
        }
    }

    protected void scanJar(File file, String packagePath) throws IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packagePath)) continue;
            this.handleItem(name);
        }
    }

    protected void scanDir(File file, String path) {
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.scanDir(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    protected void handleItem(String name) {
        if (name.endsWith(".class")) {
            String classname = this.toClassName(name);
            try {
                Class<?> type = this.loader.loadClass(classname);
                if (this.parentType.isAssignableFrom(type)) {
                    this.classes.add(type);
                }
            }
            catch (Throwable t) {
                log.debug("could not load class: " + classname, t);
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Class<?>> getConcreteClasses() {
        LinkedHashSet concreteClassSet = new LinkedHashSet();
        for (Class<?> clazz : this.classes) {
            if (!ClassFinder.isConcrete(clazz)) continue;
            concreteClassSet.add(clazz);
        }
        return concreteClassSet;
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }
}

