> Currently, pyGitAPI is in development, so make sure you get the prerelease to get the features! If you create programs using this, there shouldn't be any breaking changes coming, but make sure to check the release notes! 
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-2-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

# pyGitAPI

[![Tests](https://github.com/DillonB07/GitAPI/actions/workflows/pytest.yml/badge.svg)](https://github.com/DillonB07/GitAPI/actions/workflows/pytest.yml)
![PyPI](https://img.shields.io/pypi/v/pygitapi?color=blue&label=PyPi&logo=pypi&logoColor=yellow)
![PyPI - Downloads](https://img.shields.io/pypi/dm/pygitapi?color=blue&label=Downloads&logo=pypi&logoColor=yellow)
![PyPI - Format](https://img.shields.io/pypi/format/pygitapi?color=blue&&label=Format&logo=pypi&logoColor=yellow)
![PyPI - Status](https://img.shields.io/pypi/status/pygitapi?color=blue&label=Status&logo=pypi&logoColor=yellow)
![PyPI - License](https://img.shields.io/pypi/l/pygitapi?color=blue&label=License&logo=pypi&logoColor=yellow)

pygitapi is a package that allows you to use the GitHub GraphQL API with ease in your Python programs.

## Installation

Anyone can use this package by installing it from PyPi via one of the following commands:

### Pip

```zsh
pip install --upgrade pygitapi
```

```zsh
pip3 install --upgrade pygitapi
```

```zsh
python -m pip install --upgrade pygitapi
```

```zsh
python3 -m pip install --upgrade pygitapi
```

> Add the `--pre` flag to get the latest pre-release

### Poetry

```zsh
poetry install pygitapi@latest
```

> Add the `--alow-prereleases` flag to get the latest pre-release

### Conda

```zsh
conda install pygitapi
```

> You will not be able to install pre-releases on conda

### Pipenv

```zsh
pipenv install --selective-upgrade pygitapi
```
> Add the `--pre` flag to get the latest pre-release

## Usage

Just import the modules you need and get started!

*Proper documentation will come at the release of v1.0.0*

## License

This project is licensed under the LGPLv3 license.

We also follow the [`all-contributors`](https://allcontributors.org/) guidelines.

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="http://jbloves27.repl.co"><img src="https://avatars.githubusercontent.com/u/76911308?v=4?s=100" width="100px;" alt=""/><br /><sub><b>kokomi simp :3</b></sub></a><br /><a href="https://github.com/DillonB07/GitAPI/commits?author=kokonut27" title="Code">💻</a> <a href="#question-kokonut27" title="Answering Questions">💬</a></td>
    <td align="center"><a href="https://dillonb07.is-a.dev"><img src="https://avatars.githubusercontent.com/u/83948303?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dillon Barnes</b></sub></a><br /><a href="https://github.com/DillonB07/GitAPI/commits?author=DillonB07" title="Code">💻</a> <a href="#infra-DillonB07" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-DillonB07" title="Maintenance">🚧</a> <a href="https://github.com/DillonB07/GitAPI/commits?author=DillonB07" title="Tests">⚠️</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
