# -*- coding: utf-8 -*-
"""
-------------------------------------------------
   File Name：     datetime
   Description :
   Author :        Asdil
   date：          2020/7/2
-------------------------------------------------
   Change Activity:
                   2020/7/2:
-------------------------------------------------
"""
__author__ = 'Asdil'
from datetime import datetime
from dateutil.parser import parse


def str_to_datetime(date):
    """str_to_datetime方法用于字符串转日期

    Parameters
    ----------
    date : str
        日期字符串：
        eg:
        2018-10-21
        20181021
        2018/10/21
        10-21 # 如果没有年份默认今年
        10/21
    Returns
    ----------
    datetime
    """
    return parse(date)


def datetime_to_str(date, milliseconds=False):
    """datetime_to_str方法用于日期边字符串

    Parameters
    ----------
    date : datetime
        日期
    milliseconds: bool
        是否保留毫秒
    Returns
    ----------
    """
    if milliseconds:
        return date.isoformat(sep=' ', timespec='milliseconds')
    else:
        return date.replace(microsecond=0).isoformat(' ')


def timestamp_to_datetime(timestamp):
    """timestamp_to_str方法用于时间戳转日期字符串

    Parameters
    ----------
    timeStamp : float
        时间戳
    Returns
    ----------
    """
    return datetime.fromtimestamp(timestamp)


def datetime_to_timestamp(date):
    """datetime_to_timestamp方法用于日期转时间戳

    Parameters
    ----------
    date : datetime
        日期
    Returns
    ----------
    """
    return datetime.timestamp(date)


def timestamp_to_str(timestamp, milliseconds=False):
    """timestamp_to_str方法用于时间戳转日期字符串

    Parameters
    ----------
    timestamp : float
        时间戳
    milliseconds : bool
        保留毫秒
    Returns
    ----------
    """
    date = timestamp_to_datetime(timestamp)
    return datetime_to_str(date, milliseconds)
