# APIs for Windows 32-bit rpcrt4 library
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'rpcrt4.main_entry':( 'int', None, 'stdcall', 'rpcrt4.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_addref':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_AddRef', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_connect':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Connect', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_countrefs':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_CountRefs', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_debugserverqueryinterface':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_DebugServerQueryInterface', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_debugserverrelease':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_DebugServerRelease', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_disconnect':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Disconnect', (('int', None),) ),
    'rpcrt4.cstdstubbuffer_invoke':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_Invoke', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_isiidsupported':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_IsIIDSupported', (('int', None), ('int', None)) ),
    'rpcrt4.cstdstubbuffer_queryinterface':( 'int', None, 'stdcall', 'rpcrt4.CStdStubBuffer_QueryInterface', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.checkverificationtrailer':( 'int', None, 'stdcall', 'rpcrt4.CheckVerificationTrailer', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.createproxyfromtypeinfo':( 'int', None, 'stdcall', 'rpcrt4.CreateProxyFromTypeInfo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.createstubfromtypeinfo':( 'int', None, 'stdcall', 'rpcrt4.CreateStubFromTypeInfo', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.dceerrorinqtexta':( 'int', None, 'stdcall', 'rpcrt4.DceErrorInqTextA', (('int', None), ('int', None)) ),
    'rpcrt4.dceerrorinqtextw':( 'int', None, 'stdcall', 'rpcrt4.DceErrorInqTextW', (('int', None), ('int', None)) ),
    'rpcrt4.dllgetclassobject':( 'int', None, 'stdcall', 'rpcrt4.DllGetClassObject', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.dllregisterserver':( 'int', None, 'cdecl', 'rpcrt4.DllRegisterServer', () ),
    'rpcrt4.globalmutexclearexternal':( 'int', None, 'cdecl', 'rpcrt4.GlobalMutexClearExternal', () ),
    'rpcrt4.globalmutexrequestexternal':( 'int', None, 'cdecl', 'rpcrt4.GlobalMutexRequestExternal', () ),
    'rpcrt4.iunknown_addref_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_AddRef_Proxy', (('int', None),) ),
    'rpcrt4.iunknown_queryinterface_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_QueryInterface_Proxy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.iunknown_release_proxy':( 'int', None, 'stdcall', 'rpcrt4.IUnknown_Release_Proxy', (('int', None),) ),
    'rpcrt4.i_rpcallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAllocate', (('DWORD', None),) ),
    'rpcrt4.i_rpcasyncabortcall':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAsyncAbortCall', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcasyncsethandle':( 'int', None, 'stdcall', 'rpcrt4.I_RpcAsyncSetHandle', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbcacheallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBCacheAllocate', (('DWORD', None),) ),
    'rpcrt4.i_rpcbcachefree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBCacheFree', (('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindingcopy':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingCopy', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindinghandletoasynchandle':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingHandleToAsyncHandle', ( ('int', None),) ),
    'rpcrt4.i_rpcbindinginqconnid':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqConnId', ( ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqdynamicendpointa':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqDynamicEndpointA', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqdynamicendpointw':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqDynamicEndpointW', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcbindinginqlocalclientpid':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqLocalClientPID', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqsecuritycontext':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqSecurityContext', ( ('int', None),) ),
    'rpcrt4.i_rpcbindinginqtransporttype':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqTransportType', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcbindinginqwireidforsnego':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingInqWireIdForSnego', ( ('int', None),) ),
    'rpcrt4.i_rpcbindingisclientlocal':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingIsClientLocal', ( ('int', None),) ),
    'rpcrt4.i_rpcbindingtostaticstringbindingw':( 'int', None, 'stdcall', 'rpcrt4.I_RpcBindingToStaticStringBindingW', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpcclearmutex':( 'int', None, 'cdecl', 'rpcrt4.I_RpcClearMutex', () ),
    'rpcrt4.i_rpcconnectioninqsockbuffsize':( 'int', None, 'stdcall', 'rpcrt4.I_RpcConnectionInqSockBuffSize', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcconnectionsetsockbuffsize':( 'int', None, 'stdcall', 'rpcrt4.I_RpcConnectionSetSockBuffSize', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcdeletemutex':( 'int', None, 'stdcall', 'rpcrt4.I_RpcDeleteMutex', () ),
    'rpcrt4.i_rpcenablewmitrace':( 'int', None, 'stdcall', 'rpcrt4.I_RpcEnableWmiTrace', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcexceptionfilter':( 'int', None, 'stdcall', 'rpcrt4.I_RpcExceptionFilter', (('int', None),) ),
    'rpcrt4.i_rpcfree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFree', (('void *', 'ptr'),) ),
    'rpcrt4.i_rpcfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFreeBuffer', (('int', None),) ),
    'rpcrt4.i_rpcfreepipebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcFreePipeBuffer', (('int', None),) ),
    'rpcrt4.i_rpcgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcGetBuffer', (('int', None),) ),
    'rpcrt4.i_rpcgetbufferwithobject':( 'int', None, 'stdcall', 'rpcrt4.I_RpcGetBufferWithObject', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.i_rpcgetcurrentcallhandle':( 'int', None, 'cdecl', 'rpcrt4.I_RpcGetCurrentCallHandle', () ),
    'rpcrt4.i_rpcgetextendederror':( 'int', None, 'cdecl', 'rpcrt4.I_RpcGetExtendedError', () ),
    'rpcrt4.i_rpcifinqtransfersyntaxes':( 'int', None, 'stdcall', 'rpcrt4.I_RpcIfInqTransferSyntaxes', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpclogevent':( 'int', None, 'stdcall', 'rpcrt4.I_RpcLogEvent', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcmapwin32status':( 'int', None, 'stdcall', 'rpcrt4.I_RpcMapWin32Status', (('int', None),) ),
    'rpcrt4.i_rpcnegotiatetransfersyntax':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNegotiateTransferSyntax', (('int', None),) ),
    'rpcrt4.i_rpcnsbindingsetentrynamea':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsBindingSetEntryNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsbindingsetentrynamew':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsBindingSetEntryNameW', ( ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsinterfaceexported':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsInterfaceExported', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcnsinterfaceunexported':( 'int', None, 'stdcall', 'rpcrt4.I_RpcNsInterfaceUnexported', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcparsesecurity':( 'int', None, 'stdcall', 'rpcrt4.I_RpcParseSecurity', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcpauseexecution':( 'int', None, 'cdecl', 'rpcrt4.I_RpcPauseExecution', () ),
    'rpcrt4.i_rpcproxynewconnection':( 'int', None, 'stdcall', 'rpcrt4.I_RpcProxyNewConnection', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcreallocpipebuffer':( 'int', None, 'stdcall', 'rpcrt4.I_RpcReallocPipeBuffer', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcreceive':( 'int', None, 'stdcall', 'rpcrt4.I_RpcReceive', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcrequestmutex':( 'int', None, 'stdcall', 'rpcrt4.I_RpcRequestMutex', (('int', None),) ),
    'rpcrt4.i_rpcsend':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSend', (('int', None),) ),
    'rpcrt4.i_rpcsendreceive':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSendReceive', (('int', None),) ),
    'rpcrt4.i_rpcserverallocateipport':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerAllocateIpPort', (('int', None), ('int', None)) ),
    'rpcrt4.i_rpcservercheckclientrestriction':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerCheckClientRestriction', () ),
    'rpcrt4.i_rpcserverinqaddresschangefn':( 'int', None, 'cdecl', 'rpcrt4.I_RpcServerInqAddressChangeFn', () ),
    'rpcrt4.i_rpcserverinqlocalconnaddress':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerInqLocalConnAddress', ( ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpcserverinqtransporttype':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerInqTransportType', (('int', None),) ),
    'rpcrt4.i_rpcserverregisterforwardfunction':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerRegisterForwardFunction', (('int', None),) ),
    'rpcrt4.i_rpcserversetaddresschangefn':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerSetAddressChangeFn', (('int', None),) ),
    'rpcrt4.i_rpcserveruseprotseq2a':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseq2A', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcserveruseprotseq2w':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseq2W', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.i_rpcserveruseprotseqep2a':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseqEp2A', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.i_rpcserveruseprotseqep2w':( 'int', None, 'stdcall', 'rpcrt4.I_RpcServerUseProtseqEp2W', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.i_rpcsessionstrictcontexthandle':( 'int', None, 'cdecl', 'rpcrt4.I_RpcSessionStrictContextHandle', () ),
    'rpcrt4.i_rpcssdontserializecontext':( 'int', None, 'cdecl', 'rpcrt4.I_RpcSsDontSerializeContext', () ),
    'rpcrt4.i_rpcsystemfunction001':( 'int', None, 'stdcall', 'rpcrt4.I_RpcSystemFunction001', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransconnectionallocatepacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionAllocatePacket', (('int', None), ('DWORD', None)) ),
    'rpcrt4.i_rpctransconnectionfreepacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionFreePacket', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpctransconnectionreallocpacket':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransConnectionReallocPacket', (('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'rpcrt4.i_rpctransdatagramallocate':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramAllocate', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransdatagramallocate2':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramAllocate2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.i_rpctransdatagramfree':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransDatagramFree', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.i_rpctransgetthreadevent':( 'int', None, 'cdecl', 'rpcrt4.I_RpcTransGetThreadEvent', () ),
    'rpcrt4.i_rpctransiocancelled':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransIoCancelled', ( ('void *', 'ptr'),) ),
    'rpcrt4.i_rpctransservernewconnection':( 'int', None, 'stdcall', 'rpcrt4.I_RpcTransServerNewConnection', () ),
    'rpcrt4.i_rpcturnoneeinfopropagation':( 'int', None, 'cdecl', 'rpcrt4.I_RpcTurnOnEEInfoPropagation', () ),
    'rpcrt4.i_uuidcreate':( 'int', None, 'stdcall', 'rpcrt4.I_UuidCreate', (('int', None),) ),
    'rpcrt4.midl_wchar_strcpy':( 'int', None, 'stdcall', 'rpcrt4.MIDL_wchar_strcpy', (('int', None), ('int', None)) ),
    'rpcrt4.midl_wchar_strlen':( 'int', None, 'stdcall', 'rpcrt4.MIDL_wchar_strlen', (('int', None),) ),
    'rpcrt4.mesbufferhandlereset':( 'int', None, 'stdcall', 'rpcrt4.MesBufferHandleReset', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.mesdecodebufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesDecodeBufferHandleCreate', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.mesdecodeincrementalhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesDecodeIncrementalHandleCreate', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.mesencodedynbufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeDynBufferHandleCreate', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.mesencodefixedbufferhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeFixedBufferHandleCreate', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.mesencodeincrementalhandlecreate':( 'int', None, 'stdcall', 'rpcrt4.MesEncodeIncrementalHandleCreate', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.meshandlefree':( 'int', None, 'stdcall', 'rpcrt4.MesHandleFree', (('void *', 'ptr'),) ),
    'rpcrt4.mesincrementalhandlereset':( 'int', None, 'stdcall', 'rpcrt4.MesIncrementalHandleReset', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.mesinqprocencodingid':( 'int', None, 'stdcall', 'rpcrt4.MesInqProcEncodingId', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrccontextbinding':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextBinding', (('int', None),) ),
    'rpcrt4.ndrccontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrccontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRCContextUnmarshall', (('int', None),) ),
    'rpcrt4.ndrscontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshall', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextmarshall2':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshall2', ( ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextmarshallex':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextMarshallEx', ( ('void *', 'obj'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshall2':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshall2', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrscontextunmarshallex':( 'int', None, 'stdcall', 'rpcrt4.NDRSContextUnmarshallEx', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrcopy':( 'int', None, 'stdcall', 'rpcrt4.NDRcopy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrAllocate', (('int', None), ('int', None)) ),
    'rpcrt4.ndrasyncclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrAsyncClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrasyncservercall':( 'int', None, 'stdcall', 'rpcrt4.NdrAsyncServerCall', (('int', None),) ),
    'rpcrt4.ndrbytecountpointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrbytecountpointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrByteCountPointerUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcstdstubbuffer2_release':( 'int', None, 'stdcall', 'rpcrt4.NdrCStdStubBuffer2_Release', (('int', None), ('int', None)) ),
    'rpcrt4.ndrcstdstubbuffer_release':( 'int', None, 'stdcall', 'rpcrt4.NdrCStdStubBuffer_Release', (('int', None), ('int', None)) ),
    'rpcrt4.ndrclearoutparameters':( 'int', None, 'stdcall', 'rpcrt4.NdrClearOutParameters', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcall2':( 'int', None, 'cdecl', 'rpcrt4.NdrClientCall2', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrClientContextMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientcontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrClientContextUnmarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrClientInitialize', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrclientinitializenew':( 'int', None, 'stdcall', 'rpcrt4.NdrClientInitializeNew', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrcomplexarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexArrayUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrcomplexstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcomplexstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrcomplexstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrComplexStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrconformantarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstringunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStringUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructMemorySize', ( ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrconformantvaryingarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingArrayUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructMemorySize', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrconformantvaryingstructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrConformantVaryingStructUnmarshall', (('void *', 'ptr'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrcontexthandleinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrContextHandleInitialize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrcontexthandlesize':( 'int', None, 'stdcall', 'rpcrt4.NdrContextHandleSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrconvert':( 'int', None, 'stdcall', 'rpcrt4.NdrConvert', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrconvert2':( 'int', None, 'stdcall', 'rpcrt4.NdrConvert2', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcorrelationfree':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrcorrelationinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationInitialize', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrcorrelationpass':( 'int', None, 'stdcall', 'rpcrt4.NdrCorrelationPass', (('int', None),) ),
    'rpcrt4.ndrcreateserverinterfacefromstub':( 'int', None, 'stdcall', 'rpcrt4.NdrCreateServerInterfaceFromStub', (('int', None), ('int', None)) ),
    'rpcrt4.ndrdcomasyncclientcall':( 'int', None, 'cdecl', 'rpcrt4.NdrDcomAsyncClientCall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdcomasyncstubcall':( 'int', None, 'stdcall', 'rpcrt4.NdrDcomAsyncStubCall', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrdllcanunloadnow':( 'int', None, 'stdcall', 'rpcrt4.NdrDllCanUnloadNow', (('int', None),) ),
    'rpcrt4.ndrdllgetclassobject':( 'int', None, 'stdcall', 'rpcrt4.NdrDllGetClassObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdllregisterproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrDllRegisterProxy', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrdllunregisterproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrDllUnregisterProxy', (('int', None), ('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrencapsulatedunionbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionfree':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrencapsulatedunionunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrEncapsulatedUnionUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrfixedarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrFixedArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrFreeBuffer', (('void *', 'ptr'),) ),
    'rpcrt4.ndrfullpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerFree', (('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerinsertrefid':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerInsertRefId', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerquerypointer':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerQueryPointer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerqueryrefid':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerQueryRefId', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrfullpointerxlatfree':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerXlatFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrfullpointerxlatinit':( 'int', None, 'stdcall', 'rpcrt4.NdrFullPointerXlatInit', (('DWORD', None), ('int', None)) ),
    'rpcrt4.ndrgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrGetBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrgetdcomprotocolversion':( 'int', None, 'stdcall', 'rpcrt4.NdrGetDcomProtocolVersion', (('int', None), ('int', None)) ),
    'rpcrt4.ndrgetsimpletypebufferalignment':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeBufferAlignment', (('int', None),) ),
    'rpcrt4.ndrgetsimpletypebuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeBufferSize', (('int', None),) ),
    'rpcrt4.ndrgetsimpletypememorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrGetSimpleTypeMemorySize', (('int', None),) ),
    'rpcrt4.ndrgettypeflags':( 'int', None, 'stdcall', 'rpcrt4.NdrGetTypeFlags', (('int', None),) ),
    'rpcrt4.ndrgetusermarshalinfo':( 'int', None, 'stdcall', 'rpcrt4.NdrGetUserMarshalInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrinterfacepointermemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrinterfacepointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrInterfacePointerUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmapcommandfaultstatus':( 'int', None, 'stdcall', 'rpcrt4.NdrMapCommAndFaultStatus', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmesprocencodedecode':( 'int', None, 'cdecl', 'rpcrt4.NdrMesProcEncodeDecode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmesprocencodedecode2':( 'int', None, 'cdecl', 'rpcrt4.NdrMesProcEncodeDecode2', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmessimpletypealignsize':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeAlignSize', (('int', None),) ),
    'rpcrt4.ndrmessimpletypedecode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeDecode', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmessimpletypeencode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesSimpleTypeEncode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypealignsize':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeAlignSize', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypealignsize2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeAlignSize2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypedecode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeDecode', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypedecode2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeDecode2', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypeencode':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeEncode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypeencode2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeEncode2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrmestypefree2':( 'int', None, 'stdcall', 'rpcrt4.NdrMesTypeFree2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrnonconformantstringunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonConformantStringUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrnonencapsulatedunionbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionfree':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrnonencapsulatedunionunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrNonEncapsulatedUnionUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnsgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrNsGetBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrnssendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrNsSendReceive', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndroleallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrOleAllocate', (('int', None),) ),
    'rpcrt4.ndrolefree':( 'int', None, 'stdcall', 'rpcrt4.NdrOleFree', (('int', None),) ),
    'rpcrt4.ndroutinit':( 'int', None, 'stdcall', 'rpcrt4.NdrOutInit', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreclientbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreClientBufferSize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreclientmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreClientMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreserverinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreServerInitialize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpartialignoreserverunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPartialIgnoreServerUnmarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerfree':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpointermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrpointermemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpointerunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrPointerUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrproxyerrorhandler':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyErrorHandler', (('int', None),) ),
    'rpcrt4.ndrproxyfreebuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyFreeBuffer', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrproxygetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyGetBuffer', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrproxyinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrProxyInitialize', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrproxysendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrProxySendReceive', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrrangeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrRangeUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrrpcsmclientallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmClientAllocate', (('int', None),) ),
    'rpcrt4.ndrrpcsmclientfree':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmClientFree', (('int', None),) ),
    'rpcrt4.ndrrpcsmsetclienttoosf':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSmSetClientToOsf', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssdefaultallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDefaultAllocate', (('DWORD', None),) ),
    'rpcrt4.ndrrpcssdefaultfree':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDefaultFree', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssdisableallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsDisableAllocate', (('void *', 'ptr'),) ),
    'rpcrt4.ndrrpcssenableallocate':( 'int', None, 'stdcall', 'rpcrt4.NdrRpcSsEnableAllocate', (('int', None),) ),
    'rpcrt4.ndrsendreceive':( 'int', None, 'stdcall', 'rpcrt4.NdrSendReceive', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrservercall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerCall', (('int', None),) ),
    'rpcrt4.ndrservercall2':( 'int', None, 'stdcall', 'rpcrt4.NdrServerCall2', (('int', None),) ),
    'rpcrt4.ndrservercontextmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrservercontextnewmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextNewMarshall', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrservercontextnewunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextNewUnmarshall', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.ndrservercontextunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerContextUnmarshall', (('int', None),) ),
    'rpcrt4.ndrserverinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitialize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrserverinitializemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeMarshall', (('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializenew':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeNew', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializepartial':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializePartial', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrserverinitializeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerInitializeUnmarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrservermarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerMarshall', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrserverunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrServerUnmarshall', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrsimplestructbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructfree':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimplestructmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructMemorySize', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.ndrsimplestructunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleStructUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrsimpletypemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleTypeMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrsimpletypeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrSimpleTypeUnmarshall', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrstubcall':( 'int', None, 'stdcall', 'rpcrt4.NdrStubCall', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubcall2':( 'int', None, 'stdcall', 'rpcrt4.NdrStubCall2', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubforwardingfunction':( 'int', None, 'stdcall', 'rpcrt4.NdrStubForwardingFunction', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrstubgetbuffer':( 'int', None, 'stdcall', 'rpcrt4.NdrStubGetBuffer', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrstubinitialize':( 'int', None, 'stdcall', 'rpcrt4.NdrStubInitialize', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrstubinitializemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrStubInitializeMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypeflags':( 'int', None, 'cdecl', 'rpcrt4.NdrTypeFlags', () ),
    'rpcrt4.ndrtypefree':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypemarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypesize':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrtypeunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrTypeUnmarshall', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrunmarshallbasetypeinline':( 'int', None, 'stdcall', 'rpcrt4.NdrUnmarshallBasetypeInline', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalfree':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalMarshall', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.ndrusermarshalmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalsimpletypeconvert':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalSimpleTypeConvert', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrusermarshalunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrUserMarshalUnmarshall', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraybuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayBufferSize', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarrayfree':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraymarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayMarshall', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarraymemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrvaryingarrayunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrVaryingArrayUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasbuffersize':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsBufferSize', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasfree':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsFree', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsMarshall', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasmemorysize':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.ndrxmitorrepasunmarshall':( 'int', None, 'stdcall', 'rpcrt4.NdrXmitOrRepAsUnmarshall', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpcreateproxy':( 'int', None, 'stdcall', 'rpcrt4.NdrpCreateProxy', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpcreatestub':( 'int', None, 'stdcall', 'rpcrt4.NdrpCreateStub', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpgetprocformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetProcFormatString', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.ndrpgettypeformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetTypeFormatString', ( ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.ndrpgettypegencookie':( 'int', None, 'stdcall', 'rpcrt4.NdrpGetTypeGenCookie', (('int', None),) ),
    'rpcrt4.ndrpmemoryincrement':( 'int', None, 'stdcall', 'rpcrt4.NdrpMemoryIncrement', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.ndrpreleasetypeformatstring':( 'int', None, 'stdcall', 'rpcrt4.NdrpReleaseTypeFormatString', (('void *', 'ptr'),) ),
    'rpcrt4.ndrpreleasetypegencookie':( 'int', None, 'stdcall', 'rpcrt4.NdrpReleaseTypeGenCookie', () ),
    'rpcrt4.ndrpsetrpcssdefaults':( 'int', None, 'stdcall', 'rpcrt4.NdrpSetRpcSsDefaults', (('int', None), ('int', None)) ),
    'rpcrt4.ndrpvarvtoftypedesc':( 'int', None, 'stdcall', 'rpcrt4.NdrpVarVtOfTypeDesc', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcasyncabortcall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncAbortCall', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcasynccancelcall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncCancelCall', (('int', None), ('int', None)) ),
    'rpcrt4.rpcasynccompletecall':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncCompleteCall', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcasyncgetcallstatus':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncGetCallStatus', (('int', None),) ),
    'rpcrt4.rpcasyncinitializehandle':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncInitializeHandle', (('int', None), ('int', None)) ),
    'rpcrt4.rpcasyncregisterinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcAsyncRegisterInfo', (('int', None),) ),
    'rpcrt4.rpcbindingcopy':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingCopy', ( ('int', None),) ),
    'rpcrt4.rpcbindingfree':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingfromstringbindinga':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFromStringBindingA', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcbindingfromstringbindingw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingFromStringBindingW', (('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclienta':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientExW', ( ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthclientw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthClientW', ( ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfoexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoExW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqAuthInfoW', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindinginqobject':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqObject', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcbindinginqoption':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingInqOption', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingreset':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingReset', () ),
    'rpcrt4.rpcbindingserverfromclient':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingServerFromClient', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingsetauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfoexa':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfoexw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoExW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetAuthInfoW', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingsetobject':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetObject', ( ('void *', 'obj'),) ),
    'rpcrt4.rpcbindingsetoption':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingSetOption', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcbindingtostringbindinga':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingToStringBindingA', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingtostringbindingw':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingToStringBindingW', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcbindingvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcBindingVectorFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpccancelthread':( 'int', None, 'stdcall', 'rpcrt4.RpcCancelThread', (('int', None),) ),
    'rpcrt4.rpccancelthreadex':( 'int', None, 'stdcall', 'rpcrt4.RpcCancelThreadEx', (('int', None), ('int', None)) ),
    'rpcrt4.rpccertgenerateprincipalnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcCertGeneratePrincipalNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpccertgenerateprincipalnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcCertGeneratePrincipalNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcepregistera':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcepregisternoreplacea':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterNoReplaceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcepregisternoreplacew':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterNoReplaceW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcepregisterw':( 'int', None, 'stdcall', 'rpcrt4.RpcEpRegisterW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcepresolvebinding':( 'int', None, 'stdcall', 'rpcrt4.RpcEpResolveBinding', ( ('int', None),) ),
    'rpcrt4.rpcepunregister':( 'int', None, 'stdcall', 'rpcrt4.RpcEpUnregister', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerroraddrecord':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorAddRecord', (('int', None),) ),
    'rpcrt4.rpcerrorclearinformation':( 'int', None, 'cdecl', 'rpcrt4.RpcErrorClearInformation', () ),
    'rpcrt4.rpcerrorendenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorEndEnumeration', (('int', None),) ),
    'rpcrt4.rpcerrorgetnextrecord':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorGetNextRecord', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorgetnumberofrecords':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorGetNumberOfRecords', (('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorloaderrorinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorLoadErrorInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorresetenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorResetEnumeration', (('int', None),) ),
    'rpcrt4.rpcerrorsaveerrorinfo':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorSaveErrorInfo', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcerrorstartenumeration':( 'int', None, 'stdcall', 'rpcrt4.RpcErrorStartEnumeration', (('int', None),) ),
    'rpcrt4.rpcfreeauthorizationcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcFreeAuthorizationContext', (('int', None),) ),
    'rpcrt4.rpcgetauthorizationcontextforclient':( 'int', None, 'stdcall', 'rpcrt4.RpcGetAuthorizationContextForClient', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcifidvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcIfIdVectorFree', (('int', None),) ),
    'rpcrt4.rpcifinqid':( 'int', None, 'stdcall', 'rpcrt4.RpcIfInqId', (('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcimpersonateclient':( 'int', None, 'stdcall', 'rpcrt4.RpcImpersonateClient', () ),
    'rpcrt4.rpcmgmtenableidlecleanup':( 'int', None, 'cdecl', 'rpcrt4.RpcMgmtEnableIdleCleanup', () ),
    'rpcrt4.rpcmgmtepeltinqbegin':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqBegin', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtepeltinqdone':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqDone', (('int', None),) ),
    'rpcrt4.rpcmgmtepeltinqnexta':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqNextA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtepeltinqnextw':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpEltInqNextW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcmgmtepunregister':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtEpUnregister', ( ('void *', 'obj'), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcmgmtinqcomtimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqComTimeout', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcmgmtinqdefaultprotectlevel':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqDefaultProtectLevel', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqifids':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqIfIds', (('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqserverprincnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqServerPrincNameA', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtinqserverprincnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqServerPrincNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcmgmtinqstats':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtInqStats', (('int', None), ('int', None)) ),
    'rpcrt4.rpcmgmtisserverlistening':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtIsServerListening', (('int', None),) ),
    'rpcrt4.rpcmgmtsetauthorizationfn':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetAuthorizationFn', (('int', None),) ),
    'rpcrt4.rpcmgmtsetcanceltimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetCancelTimeout', (('int', None),) ),
    'rpcrt4.rpcmgmtsetcomtimeout':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetComTimeout', ( ('int', None),) ),
    'rpcrt4.rpcmgmtsetserverstacksize':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtSetServerStackSize', (('int', None),) ),
    'rpcrt4.rpcmgmtstatsvectorfree':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtStatsVectorFree', (('void *', 'ptr'),) ),
    'rpcrt4.rpcmgmtstopserverlistening':( 'int', None, 'stdcall', 'rpcrt4.RpcMgmtStopServerListening', (('int', None),) ),
    'rpcrt4.rpcmgmtwaitserverlisten':( 'int', None, 'cdecl', 'rpcrt4.RpcMgmtWaitServerListen', () ),
    'rpcrt4.rpcnetworkinqprotseqsa':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkInqProtseqsA', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcnetworkinqprotseqsw':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkInqProtseqsW', (('int', None),) ),
    'rpcrt4.rpcnetworkisprotseqvalida':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkIsProtseqValidA', (('int', None),) ),
    'rpcrt4.rpcnetworkisprotseqvalidw':( 'int', None, 'stdcall', 'rpcrt4.RpcNetworkIsProtseqValidW', (('void *', 'ptr'),) ),
    'rpcrt4.rpcnsbindinginqentrynamea':( 'int', None, 'stdcall', 'rpcrt4.RpcNsBindingInqEntryNameA', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcnsbindinginqentrynamew':( 'int', None, 'stdcall', 'rpcrt4.RpcNsBindingInqEntryNameW', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcobjectinqtype':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectInqType', ( ('int', None),) ),
    'rpcrt4.rpcobjectsetinqfn':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectSetInqFn', (('int', None),) ),
    'rpcrt4.rpcobjectsettype':( 'int', None, 'stdcall', 'rpcrt4.RpcObjectSetType', ( ('void *', 'obj'),) ),
    'rpcrt4.rpcprotseqvectorfreea':( 'int', None, 'stdcall', 'rpcrt4.RpcProtseqVectorFreeA', (('int', None),) ),
    'rpcrt4.rpcprotseqvectorfreew':( 'int', None, 'stdcall', 'rpcrt4.RpcProtseqVectorFreeW', (('void *', 'ptr'),) ),
    'rpcrt4.rpcraiseexception':( 'int', None, 'stdcall', 'rpcrt4.RpcRaiseException', (('int', None),) ),
    'rpcrt4.rpcreverttoself':( 'int', None, 'cdecl', 'rpcrt4.RpcRevertToSelf', () ),
    'rpcrt4.rpcreverttoselfex':( 'int', None, 'stdcall', 'rpcrt4.RpcRevertToSelfEx', () ),
    'rpcrt4.rpcserverinqbindings':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqBindings', (('int', None),) ),
    'rpcrt4.rpcserverinqcallattributesa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqCallAttributesA', ( ('int', None),) ),
    'rpcrt4.rpcserverinqcallattributesw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqCallAttributesW', ( ('void *', 'ptr'),) ),
    'rpcrt4.rpcserverinqdefaultprincnamea':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqDefaultPrincNameA', ( ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverinqdefaultprincnamew':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqDefaultPrincNameW', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserverinqif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerInqIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverlisten':( 'int', None, 'stdcall', 'rpcrt4.RpcServerListen', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterauthinfoa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterAuthInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterauthinfow':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterAuthInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverregisterif2':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIf2', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcserverregisterifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerRegisterIfEx', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcservertestcancel':( 'int', None, 'stdcall', 'rpcrt4.RpcServerTestCancel', () ),
    'rpcrt4.rpcserverunregisterif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUnregisterIf', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserverunregisterifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUnregisterIfEx', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.rpcserveruseallprotseqs':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqs', ( ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsEx', ( ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsif':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsIf', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseallprotseqsifex':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseAllProtseqsIfEx', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcserveruseprotseqepexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpExW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqepw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqEpW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqExA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcserveruseprotseqexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqExW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifexa':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfExA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifexw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfExW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqifw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqIfW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveruseprotseqw':( 'int', None, 'stdcall', 'rpcrt4.RpcServerUseProtseqW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcserveryield':( 'int', None, 'cdecl', 'rpcrt4.RpcServerYield', () ),
    'rpcrt4.rpcsmallocate':( 'int', None, 'stdcall', 'rpcrt4.RpcSmAllocate', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsmclientfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmClientFree', (('int', None),) ),
    'rpcrt4.rpcsmdestroyclientcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcSmDestroyClientContext', (('int', None),) ),
    'rpcrt4.rpcsmdisableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSmDisableAllocate', () ),
    'rpcrt4.rpcsmenableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSmEnableAllocate', () ),
    'rpcrt4.rpcsmfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmFree', (('int', None),) ),
    'rpcrt4.rpcsmgetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSmGetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcsmsetclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSetClientAllocFree', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsmsetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcsmswapclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSmSwapClientAllocFree', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcssallocate':( 'int', None, 'stdcall', 'rpcrt4.RpcSsAllocate', (('int', None),) ),
    'rpcrt4.rpcsscontextlockexclusive':( 'int', None, 'stdcall', 'rpcrt4.RpcSsContextLockExclusive', ( ('int', None),) ),
    'rpcrt4.rpcsscontextlockshared':( 'int', None, 'stdcall', 'rpcrt4.RpcSsContextLockShared', ( ('int', None),) ),
    'rpcrt4.rpcssdestroyclientcontext':( 'int', None, 'stdcall', 'rpcrt4.RpcSsDestroyClientContext', (('void *', 'ptr'),) ),
    'rpcrt4.rpcssdisableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSsDisableAllocate', () ),
    'rpcrt4.rpcssenableallocate':( 'int', None, 'cdecl', 'rpcrt4.RpcSsEnableAllocate', () ),
    'rpcrt4.rpcssfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsFree', (('int', None),) ),
    'rpcrt4.rpcssgetcontextbinding':( 'int', None, 'stdcall', 'rpcrt4.RpcSsGetContextBinding', (('int', None), ('int', None)) ),
    'rpcrt4.rpcssgetthreadhandle':( 'int', None, 'cdecl', 'rpcrt4.RpcSsGetThreadHandle', () ),
    'rpcrt4.rpcsssetclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSetClientAllocFree', (('int', None), ('int', None)) ),
    'rpcrt4.rpcsssetthreadhandle':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSetThreadHandle', (('int', None),) ),
    'rpcrt4.rpcssswapclientallocfree':( 'int', None, 'stdcall', 'rpcrt4.RpcSsSwapClientAllocFree', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.rpcstringbindingcomposea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingComposeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringbindingcomposew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingComposeW', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringbindingparsea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingParseA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'rpcrt4.rpcstringbindingparsew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringBindingParseW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.rpcstringfreea':( 'int', None, 'stdcall', 'rpcrt4.RpcStringFreeA', (('void *', 'ptr'),) ),
    'rpcrt4.rpcstringfreew':( 'int', None, 'stdcall', 'rpcrt4.RpcStringFreeW', (('void *', 'ptr'),) ),
    'rpcrt4.rpctestcancel':( 'int', None, 'cdecl', 'rpcrt4.RpcTestCancel', () ),
    'rpcrt4.rpcuserfree':( 'int', None, 'stdcall', 'rpcrt4.RpcUserFree', (('int', None), ('int', None)) ),
    'rpcrt4.simpletypealignment':( 'int', None, 'cdecl', 'rpcrt4.SimpleTypeAlignment', () ),
    'rpcrt4.simpletypebuffersize':( 'int', None, 'msfastcall', 'rpcrt4.SimpleTypeBufferSize', (('int', None), ('int', None)) ),
    'rpcrt4.simpletypememorysize':( 'int', None, 'msfastcall', 'rpcrt4.SimpleTypeMemorySize', (('int', None), ('int', None)) ),
    'rpcrt4.towerconstruct':( 'int', None, 'stdcall', 'rpcrt4.TowerConstruct', ( ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'rpcrt4.towerexplode':( 'int', None, 'stdcall', 'rpcrt4.TowerExplode', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'rpcrt4.uuidcompare':( 'int', None, 'stdcall', 'rpcrt4.UuidCompare', ( ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.uuidcreate':( 'int', None, 'stdcall', 'rpcrt4.UuidCreate', (('void *', 'ptr'),) ),
    'rpcrt4.uuidcreatenil':( 'int', None, 'stdcall', 'rpcrt4.UuidCreateNil', () ),
    'rpcrt4.uuidcreatesequential':( 'int', None, 'stdcall', 'rpcrt4.UuidCreateSequential', (('int', None),) ),
    'rpcrt4.uuidequal':( 'int', None, 'stdcall', 'rpcrt4.UuidEqual', ( ('void *', 'obj'), ('int', None)) ),
    'rpcrt4.uuidfromstringa':( 'int', None, 'stdcall', 'rpcrt4.UuidFromStringA', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.uuidfromstringw':( 'int', None, 'stdcall', 'rpcrt4.UuidFromStringW', (('int', None), ('void *', 'obj')) ),
    'rpcrt4.uuidhash':( 'int', None, 'stdcall', 'rpcrt4.UuidHash', ( ('int', None),) ),
    'rpcrt4.uuidisnil':( 'int', None, 'stdcall', 'rpcrt4.UuidIsNil', ( ('void *', 'ptr'),) ),
    'rpcrt4.uuidtostringa':( 'int', None, 'stdcall', 'rpcrt4.UuidToStringA', ( ('int', None),) ),
    'rpcrt4.uuidtostringw':( 'int', None, 'stdcall', 'rpcrt4.UuidToStringW', ( ('void *', 'ptr'),) ),
    'rpcrt4.char_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.char_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.char_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.char_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.data_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.data_into_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_into_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.data_size_ndr':( 'int', None, 'stdcall', 'rpcrt4.data_size_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.double_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.double_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.double_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.double_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.enum_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.enum_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.float_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.float_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.float_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.float_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.long_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.long_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.long_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.long_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.long_from_ndr_temp':( 'int', None, 'stdcall', 'rpcrt4.long_from_ndr_temp', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.pfnfreeroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnFreeRoutines', () ),
    'rpcrt4.pfnmarshallroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnMarshallRoutines', () ),
    'rpcrt4.pfnsizeroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnSizeRoutines', () ),
    'rpcrt4.pfnunmarshallroutines':( 'int', None, 'cdecl', 'rpcrt4.pfnUnmarshallRoutines', () ),
    'rpcrt4.short_array_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.short_array_from_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.short_from_ndr':( 'int', None, 'stdcall', 'rpcrt4.short_from_ndr', (('int', None), ('int', None)) ),
    'rpcrt4.short_from_ndr_temp':( 'int', None, 'stdcall', 'rpcrt4.short_from_ndr_temp', (('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_into_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_into_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_peek_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_peek_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'rpcrt4.tree_size_ndr':( 'int', None, 'stdcall', 'rpcrt4.tree_size_ndr', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    # FIXME unresolved I_RpcAbortAsyncCall -> RPCRT4.I_RpcAsyncAbortCall
    # FIXME unresolved I_RpcBindingInqDynamicEndpoint -> RPCRT4.I_RpcBindingInqDynamicEndpointW
    # FIXME unresolved I_RpcNsBindingSetEntryName -> RPCRT4.I_RpcNsBindingSetEntryNameW
    # FIXME unresolved I_RpcSetAsyncHandle -> RPCRT4.I_RpcAsyncSetHandle
    # FIXME unresolved RpcAbortAsyncCall -> RPCRT4.RpcAsyncAbortCall
    # FIXME unresolved RpcCancelAsyncCall -> RPCRT4.RpcAsyncCancelCall
    # FIXME unresolved RpcCompleteAsyncCall -> RPCRT4.RpcAsyncCompleteCall
    # FIXME unresolved RpcGetAsyncCallStatus -> RPCRT4.RpcAsyncGetCallStatus
    # FIXME unresolved RpcInitializeAsyncHandle -> RPCRT4.RpcAsyncInitializeHandle
    # FIXME unresolved RpcRegisterAsyncInfo -> RPCRT4.RpcAsyncRegisterInfo
    # FIXME unresolved RpcSsDontSerializeContext -> RPCRT4.I_RpcSsDontSerializeContext
    }
