/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
class LanguageCode {
    private static final String Arabic = "0401";
    private static final String Bulgarian = "0402";
    private static final String Catalan = "0403";
    private static final String Chinese_Traditional = "0404";
    private static final String Czech = "0405";
    private static final String Danish = "0406";
    private static final String German = "0407";
    private static final String Greek = "0408";
    private static final String English_US = "0409";
    private static final String Finnish = "040B";
    private static final String French = "040C";
    private static final String Hebrew = "040D";
    private static final String Hungarian = "040E";
    private static final String Icelandic = "040F";
    private static final String Italian = "0410";
    private static final String Japanese = "0411";
    private static final String Korean = "0412";
    private static final String Dutch = "0413";
    private static final String Norwegian_Bokmal = "0414";
    private static final String Polish = "0415";
    private static final String Portuguese_Brazil = "0416";
    private static final String Romanian = "0418";
    private static final String Russian = "0419";
    private static final String Croatian = "041A";
    private static final String Slovak = "041B";
    private static final String Albanian = "041C";
    private static final String Swedish = "041D";
    private static final String Thai = "041E";
    private static final String Turkish = "041F";
    private static final String Urdu = "0420";
    private static final String Indonesian = "0421";
    private static final String Ukrainian = "0422";
    private static final String Belarusian = "0423";
    private static final String Slovenian = "0424";
    private static final String Estonian = "0425";
    private static final String Latvian = "0426";
    private static final String Lithuanian = "0427";
    private static final String Tajik = "0428";
    private static final String Persian = "0429";
    private static final String Vietnamese = "042A";
    private static final String Armenian = "042B";
    private static final String Basque = "042D";
    private static final String Macedonian_FYROM = "042F";
    private static final String Afrikaans = "0436";
    private static final String Georgian = "0437";
    private static final String Faeroese = "0438";
    private static final String Hindi = "0439";
    private static final String Maltese = "043A";
    private static final String Yiddish = "043D";
    private static final String Malay = "043E";
    private static final String Kazakh = "043F";
    private static final String Kyrgyz = "0440";
    private static final String Swahili = "0441";
    private static final String Turkmen = "0442";
    private static final String Tatar = "0444";
    private static final String Bengali = "0445";
    private static final String Punjabi = "0446";
    private static final String Gujarati = "0447";
    private static final String Oriya = "0448";
    private static final String Tamil = "0449";
    private static final String Telugu = "044A";
    private static final String Kannada = "044B";
    private static final String Malayalam = "044C";
    private static final String Assamese = "044D";
    private static final String Marathi = "044E";
    private static final String Sanskrit = "044F";
    private static final String Mongolian = "0450";
    private static final String Galician = "0456";
    private static final String Konkani = "0457";
    private static final String Manipuri = "0458";
    private static final String Sindhi = "0459";
    private static final String Syriac = "045A";
    private static final String Sinhalese = "045B";
    private static final String Cherokee = "045C";
    private static final String Inuktitut = "045D";
    private static final String Amharic = "045E";
    private static final String Kashmiri_Arabic = "0460";
    private static final String Nepali = "0461";
    private static final String Frisian = "0462";
    private static final String Pashto = "0463";
    private static final String Filipino = "0464";
    private static final String Dhivehi = "0465";
    private static final String Edo = "0466";
    private static final String Hausa = "0468";
    private static final String Yoruba = "046A";
    private static final String Igbo = "0470";
    private static final String Kanuri = "0471";
    private static final String Oromo = "0472";
    private static final String Tigrigna_Ethiopia = "0473";
    private static final String Hawaiian = "0475";
    private static final String Latin = "0476";
    private static final String Somali = "0477";
    private static final String Yi = "0478";
    private static final String Chinese_Simplified = "0804";
    private static final String German_Swiss = "0807";
    private static final String English_UK = "0809";
    private static final String Norwegian_Nynorsk = "0814";
    private static final String Portuguese_Portugal = "0816";
    private static final String Azeri_Cyrillic = "082C";
    private static final String Uzbek_Cyrillic = "0843";
    private static final String Tigrigna_Eritrea = "0873";
    private static final String German_Austrian = "0C07";
    private static final String English_Australian = "0C09";
    private static final String Spanish = "0C0A";
    private static final String French_Canadian = "0C0C";
    private static final String Serbian_Cyrillic = "0C1A";
    private static final String English_Canadian = "1009";
    private static final Map languageMap = new HashMap();

    LanguageCode() {
    }

    static String getLanguageCode(Locale locale) {
        String code;
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            StringBuffer buff = new StringBuffer(lang);
            buff.append("_").append(country);
            code = (String)languageMap.get(buff.toString());
            if (code != null) {
                return code;
            }
        }
        if ((code = (String)languageMap.get(lang)) != null) {
            return code;
        }
        return English_US;
    }

    static {
        languageMap.put("ar", Arabic);
        languageMap.put("bg", Bulgarian);
        languageMap.put("ca", Catalan);
        languageMap.put("zh_TW", Chinese_Traditional);
        languageMap.put("zh_HK", Chinese_Traditional);
        languageMap.put("zh_MO", Chinese_Traditional);
        languageMap.put("cs", Czech);
        languageMap.put("da", Danish);
        languageMap.put("de", German);
        languageMap.put("el", Greek);
        languageMap.put("en", English_US);
        languageMap.put("fi", Finnish);
        languageMap.put("fr", French);
        languageMap.put("he", Hebrew);
        languageMap.put("iw", Hebrew);
        languageMap.put("hu", Hungarian);
        languageMap.put("is", Icelandic);
        languageMap.put("it", Italian);
        languageMap.put("ja", Japanese);
        languageMap.put("ko", Korean);
        languageMap.put("nl", Dutch);
        languageMap.put("no_NO_B", Norwegian_Bokmal);
        languageMap.put("nb", Norwegian_Bokmal);
        languageMap.put("pl", Polish);
        languageMap.put("pt_BR", Portuguese_Brazil);
        languageMap.put("ro", Romanian);
        languageMap.put("ru", Russian);
        languageMap.put("hr", Croatian);
        languageMap.put("sk", Slovak);
        languageMap.put("sq", Albanian);
        languageMap.put("sv", Swedish);
        languageMap.put("th", Thai);
        languageMap.put("tr", Turkish);
        languageMap.put("ur", Urdu);
        languageMap.put("id", Indonesian);
        languageMap.put("uk", Ukrainian);
        languageMap.put("be", Belarusian);
        languageMap.put("sl", Slovenian);
        languageMap.put("et", Estonian);
        languageMap.put("lv", Latvian);
        languageMap.put("lt", Lithuanian);
        languageMap.put("tg", Tajik);
        languageMap.put("fa", Persian);
        languageMap.put("vi", Vietnamese);
        languageMap.put("hy", Armenian);
        languageMap.put("eu", Basque);
        languageMap.put("mk", Macedonian_FYROM);
        languageMap.put("af", Afrikaans);
        languageMap.put("ka", Georgian);
        languageMap.put("fo", Faeroese);
        languageMap.put("hi", Hindi);
        languageMap.put("mt", Maltese);
        languageMap.put("yi", Yiddish);
        languageMap.put("ms", Malay);
        languageMap.put("kk", Kazakh);
        languageMap.put("ky", Kyrgyz);
        languageMap.put("sw", Swahili);
        languageMap.put("tk", Turkmen);
        languageMap.put("tt", Tatar);
        languageMap.put("bn", Bengali);
        languageMap.put("pa", Punjabi);
        languageMap.put("gu", Gujarati);
        languageMap.put("or", Oriya);
        languageMap.put("ta", Tamil);
        languageMap.put("te", Telugu);
        languageMap.put("kn", Kannada);
        languageMap.put("ml", Malayalam);
        languageMap.put("as", Assamese);
        languageMap.put("mr", Marathi);
        languageMap.put("sa", Sanskrit);
        languageMap.put("mn", Mongolian);
        languageMap.put("gl", Galician);
        languageMap.put("kok", Konkani);
        languageMap.put("mni", Manipuri);
        languageMap.put("sd", Sindhi);
        languageMap.put("syr", Syriac);
        languageMap.put("si", Sinhalese);
        languageMap.put("chr", Cherokee);
        languageMap.put("iu", Inuktitut);
        languageMap.put("am", Amharic);
        languageMap.put("ks", Kashmiri_Arabic);
        languageMap.put("ne", Nepali);
        languageMap.put("fy", Frisian);
        languageMap.put("ps", Pashto);
        languageMap.put("fil", Filipino);
        languageMap.put("dv", Dhivehi);
        languageMap.put("bin", Edo);
        languageMap.put("ha", Hausa);
        languageMap.put("yo", Yoruba);
        languageMap.put("ig", Igbo);
        languageMap.put("kr", Kanuri);
        languageMap.put("om", Oromo);
        languageMap.put("ti_ET", Tigrigna_Ethiopia);
        languageMap.put("haw", Hawaiian);
        languageMap.put("la", Latin);
        languageMap.put("so", Somali);
        languageMap.put("ii", Yi);
        languageMap.put("zh_CN", Chinese_Simplified);
        languageMap.put("zh_SG", Chinese_Simplified);
        languageMap.put("de_CH", German_Swiss);
        languageMap.put("en_GB", English_UK);
        languageMap.put("no", Norwegian_Nynorsk);
        languageMap.put("nn", Norwegian_Nynorsk);
        languageMap.put("pt_PT", Portuguese_Portugal);
        languageMap.put("az", Azeri_Cyrillic);
        languageMap.put("uz", Uzbek_Cyrillic);
        languageMap.put("ti_ER", Tigrigna_Eritrea);
        languageMap.put("de_AT", German_Austrian);
        languageMap.put("en_AU", English_Australian);
        languageMap.put("es", Spanish);
        languageMap.put("fr_CA", French_Canadian);
        languageMap.put("sr", Serbian_Cyrillic);
        languageMap.put("sh", Serbian_Cyrillic);
        languageMap.put("en_CA", English_Canadian);
    }
}

