/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.DeepClonable;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.collection.LongKeyDictionary;
import com.sas.security.BaseSecuritySupport;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public class DeepCloneSupport {
    protected LongKeyDictionary table = new LongKeyDictionary();

    public void register(Object object, Object clone) {
        long key = System.identityHashCode(object);
        this.table.set(key, clone);
    }

    public static Object clone(Object objectToClone) throws CloneNotSupportedException {
        if (objectToClone instanceof Cloneable) {
            if (objectToClone instanceof PublicClonable) {
                return ((PublicClonable)objectToClone).clone();
            }
            Object clonedObject = null;
            try {
                Method cloneMethod = BaseSecuritySupport.securitySupport.getMethod(objectToClone.getClass(), "clone", null);
                if (cloneMethod == null) {
                    String message = RB.getStringResource("DeepCloneSupport.noCloneMethod.ex.txt");
                    throw new CloneNotSupportedException(MessageFormat.format(message, objectToClone.getClass().getName()));
                }
                clonedObject = BaseSecuritySupport.securitySupport.invokeMethod(cloneMethod, objectToClone, null);
                return clonedObject;
            }
            catch (Exception exception) {
                String message = RB.getStringResource("DeepCloneSupport.cloneException.ex.txt");
                throw new CloneNotSupportedException(MessageFormat.format(message, objectToClone.getClass().getName()));
            }
        }
        return null;
    }

    public Object clone(Object object, boolean deeply) throws CloneNotSupportedException {
        if (object instanceof DeepClonable) {
            return this.clone((DeepClonable)object, deeply);
        }
        Object clone = this.registered(object);
        if (clone != null) {
            return clone;
        }
        clone = DeepCloneSupport.clone(object);
        this.register(object, clone);
        return clone;
    }

    public Object clone(DeepClonable object, boolean deeply) throws CloneNotSupportedException {
        Object clone = this.registered(object);
        if (clone == null) {
            clone = object.clone(this, deeply);
            this.register(object, clone);
        }
        return clone;
    }

    public Object registered(Object object) {
        long key = System.identityHashCode(object);
        Object clone = this.table.get(key, LongKeyDictionary.NO_SUCH_ELEMENT);
        return clone == LongKeyDictionary.NO_SUCH_ELEMENT ? null : clone;
    }
}

