/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Distance;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Similarity;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;
import org.jpmml.model.XPathUtil;

public class MeasureUtil {
    private MeasureUtil() {
    }

    public static Measure ensureMeasure(ComparisonMeasure comparisonMeasure) {
        Measure measure = comparisonMeasure.getMeasure();
        if (measure == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(comparisonMeasure.getClass()) + "/<Measure>"), (PMMLObject)comparisonMeasure);
        }
        return measure;
    }

    public static <V extends Number> Value<V> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<? extends ComparisonField<?>> comparisonFields, BitSet flags, BitSet referenceFlags) {
        Similarity measure = TypeUtil.cast(Similarity.class, (Object)comparisonMeasure.getMeasure());
        int a11 = 0;
        int a10 = 0;
        int a01 = 0;
        int a00 = 0;
        for (int i = 0; i < comparisonFields.size(); ++i) {
            if (flags.get(i)) {
                if (referenceFlags.get(i)) {
                    ++a11;
                    continue;
                }
                ++a10;
                continue;
            }
            if (referenceFlags.get(i)) {
                ++a01;
                continue;
            }
            ++a00;
        }
        Value<V> numerator = valueFactory.newValue();
        Value<V> denominator = valueFactory.newValue();
        if (measure instanceof SimpleMatching) {
            numerator.add(a11 + a00);
            denominator.add(a11 + a10 + a01 + a00);
        } else if (measure instanceof Jaccard) {
            numerator.add(a11);
            denominator.add(a11 + a10 + a01);
        } else if (measure instanceof Tanimoto) {
            numerator.add(a11 + a00);
            denominator.add(a11).add((Number)Numbers.DOUBLE_TWO, (Number)(a10 + a01)).add(a00);
        } else if (measure instanceof BinarySimilarity) {
            BinarySimilarity binarySimilarity = (BinarySimilarity)measure;
            Number c00 = binarySimilarity.getC00Parameter();
            if (c00 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_C00PARAMETER);
            }
            Number c01 = binarySimilarity.getC01Parameter();
            if (c01 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_C01PARAMETER);
            }
            Number c10 = binarySimilarity.getC10Parameter();
            if (c10 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_C10PARAMETER);
            }
            Number c11 = binarySimilarity.getC11Parameter();
            if (c11 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_C11PARAMETER);
            }
            numerator.add(c11, (Number)a11).add(c10, (Number)a10).add(c01, (Number)a01).add(c00, (Number)a00);
            Number d00 = binarySimilarity.getD00Parameter();
            if (d00 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_D00PARAMETER);
            }
            Number d01 = binarySimilarity.getD01Parameter();
            if (d01 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_D01PARAMETER);
            }
            Number d10 = binarySimilarity.getD10Parameter();
            if (d10 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_D10PARAMETER);
            }
            Number d11 = binarySimilarity.getD11Parameter();
            if (d11 == null) {
                throw new MissingAttributeException((PMMLObject)binarySimilarity, PMMLAttributes.BINARYSIMILARITY_D11PARAMETER);
            }
            denominator.add(d11, (Number)a11).add(d10, (Number)a10).add(d01, (Number)a01).add(d00, (Number)a00);
        } else {
            throw new UnsupportedElementException((PMMLObject)measure);
        }
        if (denominator.isZero()) {
            throw new UndefinedResultException();
        }
        return numerator.divide(denominator);
    }

    public static BitSet toBitSet(List<FieldValue> values) {
        BitSet result = new BitSet(values.size());
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            if (value.equalsValue(Boolean.FALSE)) {
                result.set(i, false);
                continue;
            }
            if (value.equalsValue(Boolean.TRUE)) {
                result.set(i, true);
                continue;
            }
            throw new EvaluationException("Expected " + PMMLException.formatValue(Boolean.FALSE) + " or " + PMMLException.formatValue(Boolean.TRUE) + ", got " + PMMLException.formatValue(value));
        }
        return result;
    }

    public static <V extends Number> Value<V> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<? extends ComparisonField<?>> comparisonFields, List<FieldValue> values, List<FieldValue> referenceValues, Value<V> adjustment) {
        Number innerPower;
        Number outerPower;
        Distance measure = TypeUtil.cast(Distance.class, (Object)comparisonMeasure.getMeasure());
        if (measure instanceof Euclidean) {
            innerPower = outerPower = Numbers.DOUBLE_TWO;
        } else if (measure instanceof SquaredEuclidean) {
            innerPower = Numbers.DOUBLE_TWO;
            outerPower = Numbers.DOUBLE_ONE;
        } else if (measure instanceof Chebychev || measure instanceof CityBlock) {
            innerPower = outerPower = Numbers.DOUBLE_ONE;
        } else if (measure instanceof Minkowski) {
            Minkowski minkowski = (Minkowski)measure;
            Number p = minkowski.getPParameter();
            if (p == null) {
                throw new MissingAttributeException((PMMLObject)minkowski, PMMLAttributes.MINKOWSKI_PPARAMETER);
            }
            if (p.doubleValue() < 0.0) {
                throw new InvalidAttributeException((PMMLObject)minkowski, PMMLAttributes.MINKOWSKI_PPARAMETER, p);
            }
            innerPower = outerPower = p;
        } else {
            throw new UnsupportedElementException((PMMLObject)measure);
        }
        Vector<V> distances = valueFactory.newVector(0);
        int max = comparisonFields.size();
        for (int i = 0; i < max; ++i) {
            ComparisonField<?> comparisonField = comparisonFields.get(i);
            FieldValue value = values.get(i);
            if (FieldValueUtil.isMissing(value)) continue;
            FieldValue referenceValue = referenceValues.get(i);
            Value<V> distance = MeasureUtil.evaluateInnerFunction(valueFactory, comparisonMeasure, comparisonField, value, referenceValue, innerPower);
            distances.add(distance);
        }
        if (measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof CityBlock || measure instanceof Minkowski) {
            Value<V> result = distances.sum().multiply(adjustment).inversePower(outerPower);
            return result;
        }
        if (measure instanceof Chebychev) {
            Value<V> result = distances.max().multiply(adjustment);
            return result;
        }
        throw new UnsupportedElementException((PMMLObject)measure);
    }

    private static <V extends Number> Value<V> evaluateInnerFunction(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, ComparisonField<?> comparisonField, FieldValue value, FieldValue referenceValue, Number power) {
        Value<V> distance;
        CompareFunction compareFunction = comparisonField.getCompareFunction();
        if (compareFunction == null) {
            compareFunction = comparisonMeasure.getCompareFunction();
            switch (compareFunction) {
                case ABS_DIFF: 
                case DELTA: 
                case EQUAL: {
                    break;
                }
                case GAUSS_SIM: 
                case TABLE: {
                    throw new InvalidAttributeException((PMMLObject)comparisonMeasure, (Enum<?>)compareFunction);
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)comparisonMeasure, (Enum<?>)compareFunction);
                }
            }
        }
        switch (compareFunction) {
            case ABS_DIFF: {
                distance = valueFactory.newValue(value.asNumber()).subtract(referenceValue.asNumber()).abs();
                break;
            }
            case GAUSS_SIM: {
                Number similarityScale = comparisonField.getSimilarityScale();
                if (similarityScale == null) {
                    throw new InvalidElementException((PMMLObject)comparisonField);
                }
                distance = valueFactory.newValue(value.asNumber()).subtract(referenceValue.asNumber()).gaussSim(similarityScale);
                break;
            }
            case DELTA: {
                boolean equals = value.equalsValue(referenceValue);
                distance = valueFactory.newValue(equals ? Numbers.DOUBLE_ZERO : Numbers.DOUBLE_ONE);
                break;
            }
            case EQUAL: {
                boolean equals = value.equalsValue(referenceValue);
                distance = valueFactory.newValue(equals ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO);
                break;
            }
            case TABLE: {
                throw new UnsupportedAttributeException((PMMLObject)comparisonField, (Enum<?>)compareFunction);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)comparisonField, (Enum<?>)compareFunction);
            }
        }
        distance.power(power);
        Number fieldWeight = comparisonField.getFieldWeight();
        if (fieldWeight != null) {
            distance.multiply(fieldWeight);
        }
        return distance;
    }

    public static <V extends Number> Value<V> calculateAdjustment(ValueFactory<V> valueFactory, List<FieldValue> values) {
        return MeasureUtil.calculateAdjustment(valueFactory, values, null);
    }

    public static <V extends Number> Value<V> calculateAdjustment(ValueFactory<V> valueFactory, List<FieldValue> values, List<? extends Number> adjustmentValues) {
        Value<V> sum = valueFactory.newValue();
        Value<V> nonmissingSum = valueFactory.newValue();
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            Double adjustmentValue = adjustmentValues != null ? (Number)adjustmentValues.get(i) : (Number)Numbers.DOUBLE_ONE;
            sum.add(adjustmentValue);
            if (FieldValueUtil.isMissing(value)) continue;
            nonmissingSum.add(adjustmentValue);
        }
        if (nonmissingSum.isZero()) {
            throw new UndefinedResultException();
        }
        return sum.divide(nonmissingSum);
    }
}

