/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.MissingAttributeException;

public class IndexableUtil {
    private IndexableUtil() {
    }

    public static <K, E extends PMMLObject> Map<K, E> buildMap(List<E> elements, Field keyField) {
        return IndexableUtil.buildMap(elements, keyField, false);
    }

    public static <K, E extends PMMLObject> Map<K, E> buildMap(List<E> elements, Field keyField, boolean nullable) {
        LinkedHashMap<Object, PMMLObject> result = new LinkedHashMap<Object, PMMLObject>();
        for (PMMLObject element : elements) {
            Object key = ((Indexable)element).getKey();
            if (key == null && !nullable) {
                throw new MissingAttributeException(element, keyField);
            }
            if (result.containsKey(key)) {
                throw new InvalidAttributeException(element, keyField, key);
            }
            result.put(key, element);
        }
        return result;
    }
}

