# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, StrictStr

class XTZTxStatusReceipt(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    protocol: Optional[StrictStr] = None
    chain_id: Optional[StrictStr] = None
    hash: Optional[StrictStr] = None
    branch: Optional[StrictStr] = None
    contents: Optional[Dict[str, Any]] = None
    signature: Optional[StrictStr] = None
    metadata: Optional[Dict[str, Any]] = None
    __properties = ["protocol", "chain_id", "hash", "branch", "contents", "signature", "metadata"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> XTZTxStatusReceipt:
        """Create an instance of XTZTxStatusReceipt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> XTZTxStatusReceipt:
        """Create an instance of XTZTxStatusReceipt from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return XTZTxStatusReceipt.parse_obj(obj)

        _obj = XTZTxStatusReceipt.parse_obj({
            "protocol": obj.get("protocol"),
            "chain_id": obj.get("chain_id"),
            "hash": obj.get("hash"),
            "branch": obj.get("branch"),
            "contents": obj.get("contents"),
            "signature": obj.get("signature"),
            "metadata": obj.get("metadata")
        })
        return _obj

