# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class SOLStake(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    stake_account: Optional[StrictStr] = Field(..., description="Public key of the stake account")
    vote_account: StrictStr = Field(..., description="Public key of the validator")
    withdraw_pubkey: Optional[StrictStr] = Field(..., description="Withdraw pubkey")
    state: StrictStr = Field(..., description="State of the Solan stake")
    activated_at: Optional[datetime] = Field(None, description="Date at which this stake was activated")
    activated_epoch: Optional[StrictInt] = Field(None, description="Epoch at which this stake was activated")
    deactivated_at: Optional[datetime] = Field(None, description="Date at which this stake was deactivated")
    deactivated_epoch: Optional[StrictInt] = Field(None, description="Epoch at which this stake was deactivated")
    delegated_epoch: Optional[StrictInt] = Field(None, description="Epoch at which this stake was delegated")
    balance: StrictStr = Field(..., description="Current balance in Lamport")
    rewards: StrictStr = Field(..., description="Sum of rewards rewards in Lamport earned by this stake")
    net_apy: float = Field(..., description="net annual percentage yield")
    updated_at: datetime = Field(..., description="Last date this data was updated")
    __properties = ["stake_account", "vote_account", "withdraw_pubkey", "state", "activated_at", "activated_epoch", "deactivated_at", "deactivated_epoch", "delegated_epoch", "balance", "rewards", "net_apy", "updated_at"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SOLStake:
        """Create an instance of SOLStake from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if stake_account (nullable) is None
        if self.stake_account is None:
            _dict['stake_account'] = None

        # set to None if withdraw_pubkey (nullable) is None
        if self.withdraw_pubkey is None:
            _dict['withdraw_pubkey'] = None

        # set to None if deactivated_at (nullable) is None
        if self.deactivated_at is None:
            _dict['deactivated_at'] = None

        # set to None if deactivated_epoch (nullable) is None
        if self.deactivated_epoch is None:
            _dict['deactivated_epoch'] = None

        # set to None if delegated_epoch (nullable) is None
        if self.delegated_epoch is None:
            _dict['delegated_epoch'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SOLStake:
        """Create an instance of SOLStake from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SOLStake.parse_obj(obj)

        _obj = SOLStake.parse_obj({
            "stake_account": obj.get("stake_account"),
            "vote_account": obj.get("vote_account"),
            "withdraw_pubkey": obj.get("withdraw_pubkey"),
            "state": obj.get("state"),
            "activated_at": obj.get("activated_at"),
            "activated_epoch": obj.get("activated_epoch"),
            "deactivated_at": obj.get("deactivated_at"),
            "deactivated_epoch": obj.get("deactivated_epoch"),
            "delegated_epoch": obj.get("delegated_epoch"),
            "balance": obj.get("balance"),
            "rewards": obj.get("rewards"),
            "net_apy": obj.get("net_apy"),
            "updated_at": obj.get("updated_at")
        })
        return _obj

