# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, conlist, validator
from kiln_connect.openapi_client.models.eth_post_keys_batch_response import ETHPostKeysBatchResponse
from kiln_connect.openapi_client.models.eth_post_keys_cli_response_inner import ETHPostKeysCliResponseInner
from typing import Any, List
from pydantic import StrictStr, Field

POSTETHKEYS201RESPONSEDATA_ONE_OF_SCHEMAS = ["ETHPostKeysBatchResponse", "List[ETHPostKeysCliResponseInner]"]

class PostEthKeys201ResponseData(BaseModel):
    """
    PostEthKeys201ResponseData
    """
    # data type: List[ETHPostKeysCliResponseInner]
    oneof_schema_1_validator: Optional[conlist(ETHPostKeysCliResponseInner)] = None
    # data type: ETHPostKeysBatchResponse
    oneof_schema_2_validator: Optional[ETHPostKeysBatchResponse] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(POSTETHKEYS201RESPONSEDATA_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = cls()
        error_messages = []
        match = 0
        # validate data type: List[ETHPostKeysCliResponseInner]
        try:
            instance.oneof_schema_1_validator = v
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # validate data type: ETHPostKeysBatchResponse
        if type(v) is not ETHPostKeysBatchResponse:
            error_messages.append(f"Error! Input type `{type(v)}` is not `ETHPostKeysBatchResponse`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PostEthKeys201ResponseData with oneOf schemas: ETHPostKeysBatchResponse, List[ETHPostKeysCliResponseInner]. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PostEthKeys201ResponseData with oneOf schemas: ETHPostKeysBatchResponse, List[ETHPostKeysCliResponseInner]. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> PostEthKeys201ResponseData:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> PostEthKeys201ResponseData:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into List[ETHPostKeysCliResponseInner]
        try:
            # validation
            instance.oneof_schema_1_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.oneof_schema_1_validator
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into ETHPostKeysBatchResponse
        try:
            instance.actual_instance = ETHPostKeysBatchResponse.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PostEthKeys201ResponseData with oneOf schemas: ETHPostKeysBatchResponse, List[ETHPostKeysCliResponseInner]. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PostEthKeys201ResponseData with oneOf schemas: ETHPostKeysBatchResponse, List[ETHPostKeysCliResponseInner]. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())

