# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from kiln_connect.openapi_client.models.ethtx_status_receipt_logs_inner import ETHTxStatusReceiptLogsInner

class ETHTxStatusReceipt(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    status: Optional[StrictBool] = Field(None, description="True if transaction has been confirmed")
    transaction_hash: Optional[StrictStr] = Field(None, alias="transactionHash", description="Transaction hash")
    transaction_index: Optional[float] = Field(None, alias="transactionIndex", description="Transaction index")
    block_hash: Optional[StrictStr] = Field(None, alias="blockHash", description="Block hash")
    block_number: Optional[float] = Field(None, alias="blockNumber", description="Block number")
    var_from: Optional[StrictStr] = Field(None, alias="from", description="Transaction from address")
    to: Optional[StrictStr] = Field(None, description="Transaction to address")
    contract_address: Optional[StrictStr] = Field(None, alias="contractAddress", description="Contract address called")
    cumulative_gas_used: Optional[float] = Field(None, alias="cumulativeGasUsed", description="Cumulative gas used")
    gas_used: Optional[float] = Field(None, alias="gasUsed", description="Gas used")
    effective_gas_price: Optional[float] = Field(None, alias="effectiveGasPrice", description="Gas price")
    logs: Optional[conlist(ETHTxStatusReceiptLogsInner)] = Field(None, description="Transaction logs")
    logs_bloom: Optional[StrictStr] = Field(None, alias="logsBloom")
    events: Optional[Dict[str, Any]] = None
    __properties = ["status", "transactionHash", "transactionIndex", "blockHash", "blockNumber", "from", "to", "contractAddress", "cumulativeGasUsed", "gasUsed", "effectiveGasPrice", "logs", "logsBloom", "events"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ETHTxStatusReceipt:
        """Create an instance of ETHTxStatusReceipt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in logs (list)
        _items = []
        if self.logs:
            for _item in self.logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['logs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ETHTxStatusReceipt:
        """Create an instance of ETHTxStatusReceipt from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ETHTxStatusReceipt.parse_obj(obj)

        _obj = ETHTxStatusReceipt.parse_obj({
            "status": obj.get("status"),
            "transaction_hash": obj.get("transactionHash"),
            "transaction_index": obj.get("transactionIndex"),
            "block_hash": obj.get("blockHash"),
            "block_number": obj.get("blockNumber"),
            "var_from": obj.get("from"),
            "to": obj.get("to"),
            "contract_address": obj.get("contractAddress"),
            "cumulative_gas_used": obj.get("cumulativeGasUsed"),
            "gas_used": obj.get("gasUsed"),
            "effective_gas_price": obj.get("effectiveGasPrice"),
            "logs": [ETHTxStatusReceiptLogsInner.from_dict(_item) for _item in obj.get("logs")] if obj.get("logs") is not None else None,
            "logs_bloom": obj.get("logsBloom"),
            "events": obj.get("events")
        })
        return _obj

