# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class ETHUnsignedTx(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    unsigned_tx_hash: Optional[StrictStr] = Field(None, description="Hash of the unsigned transaction")
    unsigned_tx_serialized: Optional[StrictStr] = Field(None, description="Unsigned serialized transaction")
    to: Optional[StrictStr] = Field(None, description="Contract address of the transaction recipient")
    contract_call_data: Optional[StrictStr] = Field(None, description="Hex encoded contract data to be sent with the transaction")
    amount_wei: Optional[StrictStr] = Field(None, description="Amount of ETH to send in wei")
    nonce: Optional[StrictInt] = Field(None, description="Nonce of the transaction")
    gas_limit: Optional[StrictInt] = Field(None, description="Gas limit of the transaction in gas units. We provide a default value of two times the estimated gas limit")
    max_priority_fee_per_gas_wei: Optional[StrictStr] = Field(None, description="Max priority fee per gas in wei. This is basically the miner fee. We provide a default value of 2 gwei so transactions are mined faster.")
    max_fee_per_gas_wei: Optional[StrictStr] = Field(None, description="Max fee per gas in wei. This is the maxium amount of gas that you are willing to pay for the transaction.")
    chain_id: Optional[StrictInt] = Field(None, description="Chain ID of the network")
    __properties = ["unsigned_tx_hash", "unsigned_tx_serialized", "to", "contract_call_data", "amount_wei", "nonce", "gas_limit", "max_priority_fee_per_gas_wei", "max_fee_per_gas_wei", "chain_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ETHUnsignedTx:
        """Create an instance of ETHUnsignedTx from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ETHUnsignedTx:
        """Create an instance of ETHUnsignedTx from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ETHUnsignedTx.parse_obj(obj)

        _obj = ETHUnsignedTx.parse_obj({
            "unsigned_tx_hash": obj.get("unsigned_tx_hash"),
            "unsigned_tx_serialized": obj.get("unsigned_tx_serialized"),
            "to": obj.get("to"),
            "contract_call_data": obj.get("contract_call_data"),
            "amount_wei": obj.get("amount_wei"),
            "nonce": obj.get("nonce"),
            "gas_limit": obj.get("gas_limit"),
            "max_priority_fee_per_gas_wei": obj.get("max_priority_fee_per_gas_wei"),
            "max_fee_per_gas_wei": obj.get("max_fee_per_gas_wei"),
            "chain_id": obj.get("chain_id")
        })
        return _obj

