# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ETHReward(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    var_date: Optional[date] = Field(None, alias="date", description="Day for this reward entry")
    consensus_rewards: Optional[StrictStr] = Field(None, description="Accumulated consensus rewards WEI during the day")
    execution_rewards: Optional[StrictStr] = Field(None, description="Accumulated execution rewards in WEI during the day")
    rewards: Optional[StrictStr] = Field(None, description="Accumulated consensus and execution rewards in WEI during the day")
    stake_balance: Optional[StrictStr] = Field(None, description="Staked balance in WEI that contributed to this rewards")
    gross_apy: Optional[float] = Field(None, description="Gross annual percentage yield")
    cl_apy: Optional[float] = Field(None, description="Consensus annual percentage yield")
    el_apy: Optional[float] = Field(None, description="Execution annual percentage yield")
    __properties = ["date", "consensus_rewards", "execution_rewards", "rewards", "stake_balance", "gross_apy", "cl_apy", "el_apy"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ETHReward:
        """Create an instance of ETHReward from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ETHReward:
        """Create an instance of ETHReward from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ETHReward.parse_obj(obj)

        _obj = ETHReward.parse_obj({
            "var_date": obj.get("date"),
            "consensus_rewards": obj.get("consensus_rewards"),
            "execution_rewards": obj.get("execution_rewards"),
            "rewards": obj.get("rewards"),
            "stake_balance": obj.get("stake_balance"),
            "gross_apy": obj.get("gross_apy"),
            "cl_apy": obj.get("cl_apy"),
            "el_apy": obj.get("el_apy")
        })
        return _obj

