# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ETHPostKeysCliResponseInner(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    format: Optional[StrictStr] = Field(None, description="Format of the key")
    pubkey: Optional[StrictStr] = Field(None, description="Public key of the validator")
    withdrawal_credentials: Optional[StrictStr] = Field(None, description="Withdrawals credentials of the validator")
    amount: Optional[float] = Field(None, description="Amount in GWEI that needs to be deposited to activate the validator")
    signature: Optional[StrictStr] = Field(None, description="BLS signature for the deposit data structure required to stake on the Ethereum chain")
    deposit_message_root: Optional[StrictStr] = Field(None, description="Root hash ensuring the deposit message integrity")
    deposit_data_root: Optional[StrictStr] = Field(None, description="Root hash ensuring the deposit data integrity")
    fork_version: Optional[StrictStr] = Field(None, description="Identifier for the fork version")
    network_name: Optional[StrictStr] = Field(None, description="Ethereum network for the generated validation key(s)")
    deposit_cli_version: Optional[StrictStr] = Field(None, description="Version of the deposit-cli tool used to generate the validation key")
    __properties = ["format", "pubkey", "withdrawal_credentials", "amount", "signature", "deposit_message_root", "deposit_data_root", "fork_version", "network_name", "deposit_cli_version"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ETHPostKeysCliResponseInner:
        """Create an instance of ETHPostKeysCliResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ETHPostKeysCliResponseInner:
        """Create an instance of ETHPostKeysCliResponseInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ETHPostKeysCliResponseInner.parse_obj(obj)

        _obj = ETHPostKeysCliResponseInner.parse_obj({
            "format": obj.get("format"),
            "pubkey": obj.get("pubkey"),
            "withdrawal_credentials": obj.get("withdrawal_credentials"),
            "amount": obj.get("amount"),
            "signature": obj.get("signature"),
            "deposit_message_root": obj.get("deposit_message_root"),
            "deposit_data_root": obj.get("deposit_data_root"),
            "fork_version": obj.get("fork_version"),
            "network_name": obj.get("network_name"),
            "deposit_cli_version": obj.get("deposit_cli_version")
        })
        return _obj

