# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist

class ETHOperationDeposit(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    type: Optional[StrictStr] = Field(None, description="type of the operation")
    time: Optional[datetime] = Field(None, description="Time of the operation")
    validator_address: Optional[StrictStr] = Field(None, description="Validator address of the operation")
    tx_hash: Optional[StrictStr] = Field(None, description="Hash of the transaction")
    tx_sender: Optional[StrictStr] = Field(None, description="Address of the sender of the transaction")
    tx_gas_used: Optional[StrictStr] = Field(None, description="Gas used by the transaction in WEI")
    tx_effective_gas_price: Optional[StrictStr] = Field(None, description="Effective gas price used for this TX in WEI")
    proxies: Optional[conlist(StrictStr)] = Field(None, description="Ordered list of smart-contracts in the calling chain")
    block: Optional[StrictInt] = Field(None, description="Block number containing the transaction")
    block_base_fee: Optional[StrictStr] = Field(None, description="Base fee used for this block in WEI")
    withdrawal_credentials: Optional[StrictStr] = Field(None, description="Withdrawal credentials of the deposit")
    amount: Optional[StrictStr] = Field(None, description="Amount in WEI of the deposit transaction")
    __properties = ["type", "time", "validator_address", "tx_hash", "tx_sender", "tx_gas_used", "tx_effective_gas_price", "proxies", "block", "block_base_fee", "withdrawal_credentials", "amount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ETHOperationDeposit:
        """Create an instance of ETHOperationDeposit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ETHOperationDeposit:
        """Create an instance of ETHOperationDeposit from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ETHOperationDeposit.parse_obj(obj)

        _obj = ETHOperationDeposit.parse_obj({
            "type": obj.get("type"),
            "time": obj.get("time"),
            "validator_address": obj.get("validator_address"),
            "tx_hash": obj.get("tx_hash"),
            "tx_sender": obj.get("tx_sender"),
            "tx_gas_used": obj.get("tx_gas_used"),
            "tx_effective_gas_price": obj.get("tx_effective_gas_price"),
            "proxies": obj.get("proxies"),
            "block": obj.get("block"),
            "block_base_fee": obj.get("block_base_fee"),
            "withdrawal_credentials": obj.get("withdrawal_credentials"),
            "amount": obj.get("amount")
        })
        return _obj

