# coding: utf-8

"""
    Kiln API Docs (dev)

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, conlist
from kiln_connect.openapi_client.models.account_portfolio_protocols_inner import AccountPortfolioProtocolsInner

class AccountPortfolio(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    total_balance_usd: Optional[float] = Field(None, description="Total USD balance of all the account's stakes")
    total_rewards_usd: Optional[float] = Field(None, description="Total USD of rewards earned from all the account's stakes")
    total_stakes: Optional[StrictInt] = Field(None, description="Total number of stakes")
    total_active_stakes: Optional[StrictInt] = Field(None, description="Total number of stakes actively collecting rewards")
    protocols: Optional[conlist(AccountPortfolioProtocolsInner)] = Field(None, description="List of protocols staked within the account")
    __properties = ["total_balance_usd", "total_rewards_usd", "total_stakes", "total_active_stakes", "protocols"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountPortfolio:
        """Create an instance of AccountPortfolio from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in protocols (list)
        _items = []
        if self.protocols:
            for _item in self.protocols:
                if _item:
                    _items.append(_item.to_dict())
            _dict['protocols'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountPortfolio:
        """Create an instance of AccountPortfolio from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountPortfolio.parse_obj(obj)

        _obj = AccountPortfolio.parse_obj({
            "total_balance_usd": obj.get("total_balance_usd"),
            "total_rewards_usd": obj.get("total_rewards_usd"),
            "total_stakes": obj.get("total_stakes"),
            "total_active_stakes": obj.get("total_active_stakes"),
            "protocols": [AccountPortfolioProtocolsInner.from_dict(_item) for _item in obj.get("protocols")] if obj.get("protocols") is not None else None
        })
        return _obj

