.SUFFIXES: .c .cpp .cc .cu .h .f .f90 .f90

## Determine machine architecture
MACHINE = $(shell uname -m)
SYSTEM = $(shell uname -s)

## Where to put binaries
BINDIR = .

### Complete Fortran compiler flags
INCLUDEFLAGS = -I. -I$(SRCDIR) -I$(SRCDIR)/support -I$(SRCDIR)/potentials
F90FLAGS += $(INCLUDEFLAGS)

### Complete C compiler flags
CFLAGS += -I$(SRCDIR) -I$(SRCDIR)/support -I$(SRCDIR)/notb

### Include auto-generated source listings. These are generated by
### listclasses.py from the tools directory. See call to listclasses.py below.
$(shell touch _Makefile.modules)
include _Makefile.modules

## Source search paths
VPATH = \
	. \
	$(SRCDIR) \
	$(SRCDIR)/core \
	$(SRCDIR)/lammps \
	$(SRCDIR)/notb \
	$(SRCDIR)/notb/dense \
	$(SRCDIR)/notb/dense/solver \
	$(SRCDIR)/notb/dense/analysis \
	$(SRCDIR)/potentials \
	$(SRCDIR)/potentials/bop \
	$(SRCDIR)/potentials/bop/brenner \
	$(SRCDIR)/potentials/bop/juslin \
	$(SRCDIR)/potentials/bop/kumagai \
	$(SRCDIR)/potentials/bop/tersoff \
	$(SRCDIR)/potentials/bop/rebo2 \
	$(SRCDIR)/potentials/coulomb \
	$(SRCDIR)/potentials/eam \
	$(SRCDIR)/potentials/non_newtonian \
	$(SRCDIR)/potentials/pair_potentials \
	$(SRCDIR)/potentials/dispersion \
	$(SRCDIR)/potentials_nonfree/bop/rebo2x \
	$(SRCDIR)/potentials_nonfree/bop/rebo2sich \
	$(SRCDIR)/potentials_nonfree/bop/rebo2coh \
	$(SRCDIR)/potentials_nonfree/bop/rebo2chx \
	$(SRCDIR)/potentials_nonfree/coulomb \
	$(SRCDIR)/qeq \
	$(SRCDIR)/special \
	$(SRCDIR)/standalone \
	$(SRCDIR)/support \
	$(SRCDIR)/unittests


### Core support library
CORE_SUPPLIB = \
	c_f.f90 \
	error.f90 \
	System.f90 \
	MPI_context.f90 \
	Units.f90 \
	c_linearalgebra.cpp \
	f_linearalgebra.f90 \
	PeriodicTable.f90 \
	f_ptrdict.f90 \
	c_ptrdict.c \
	io.f90 \
	f_logging.f90 \
	c_logging.c \
	misc.f90 \
	data.f90 \
	timer.f90 \
	tls.f90 \
	simple_spline.f90 \
	nonuniform_spline.f90 \
	cutoff.f90 \
	histogram1d.f90 \
	supplib.f90 \
	table2d.f90 \
	table3d.f90 \
	table4d.f90 \
	anderson_mixer.f90

## LAMMPS support library
LAMMPS_SUPPLIB = \
	$(CORE_SUPPLIB) \
	lammps_particles.f90 \
	extrapolation.f90 \
	lammps_neighbors.f90 \
	lammps_filter.f90 \
	coulomb_dispatch.f90 \
	versioninfo.f90 \
	atomistica.f90


## LAMMPS dispatch
LAMMPS_DISPATCH = \
	potentials_factory_c.c \
	potentials_factory_f90.f90
LAMMPS_DISPATCH_O1 = $(LAMMPS_DISPATCH:.c=.o)
LAMMPS_DISPATCH_O = $(LAMMPS_DISPATCH_O1:.f90=.o)


## Everything we need for LAMMPS support
LAMMPS_ALL = \
	$(LAMMPS_SUPPLIB) \
	$(POTENTIALS_MODS) \
	$(LAMMPS_DISPATCH)
LAMMPS_ALL_O4 = $(LAMMPS_ALL:.cpp=.o)
LAMMPS_ALL_O3 = $(LAMMPS_ALL_O4:.c=.o)
LAMMPS_ALL_O2 = $(LAMMPS_ALL_O3:.f=.o)
LAMMPS_ALL_O1 = $(LAMMPS_ALL_O2:.f90=.o)
LAMMPS_ALL_O = $(LAMMPS_ALL_O1:.f90=.o)


## I/O library
IOLIB = \
	native_io.f90 \
	cfg.f90 \
	pdb.f90 \
	vtk.f90 \
	nc.f90 \
	xyz_f90.f90 \
	lammps_data.f90 \
	input_trajectory.f90


## Support library for standalone code
STANDALONE_MODS = \
	$(COULOMB_MODS) \
	coulomb_dispatch.f90 \
	$(POTENTIALS_MODS) \
	potentials_dispatch.f90 \
	$(INTEGRATORS_MODS) \
	integrators_dispatch.f90 \
	$(FP_MODS) \
	$(CALLABLES_MODS) \
	callables_dispatch.f90
STANDALONE_MODS_O5 = $(STANDALONE_MODS:.cu=.o)
STANDALONE_MODS_O4 = $(STANDALONE_MODS_O5:.cpp=.o)
STANDALONE_MODS_O3 = $(STANDALONE_MODS_O4:.c=.o)
STANDALONE_MODS_O2 = $(STANDALONE_MODS_O3:.f=.o)
STANDALONE_MODS_O1 = $(STANDALONE_MODS_O2:.f90=.o)
STANDALONE_MODS_O = $(STANDALONE_MODS_O1:.f90=.o)


### Dispatch for standalone code
STANDALONE_DISPATCH = \
	integrators_factory_c.c \
	potentials_factory_c.c \
	coulomb_factory_c.c \
	callables_factory_c.c \
	integrators_factory_f90.f90 \
	potentials_factory_f90.f90 \
	coulomb_factory_f90.f90 \
	callables_factory_f90.f90
STANDALONE_DISPATCH_O = $(STANDALONE_DISPATCH:.f90=.o)


## Everything we need for the standalone code
STANDALONE_ALL = \
	$(CORE_SUPPLIB) \
	signal_handler.f90 \
	r250.f \
	rng.f90 \
	particles.f90 \
	extrapolation.f90 \
	domain_decomposition.f90 \
	neighbors.f90 \
	filter.f90 \
	molecules.f90 \
	dynamics.f90 \
	cyclic.f90 \
	symmetry.f90 \
	versioninfo.f90 \
	atomistica.f90 \
	$(IOLIB) \
	lucy.f90 \
	square.f90 \
	interpolation_kernels_dispatch.f90 \
	$(STANDALONE_MODS) \
	$(STANDALONE_DISPATCH)
STANDALONE_ALL_O4 = $(STANDALONE_ALL:.cpp=.o)
STANDALONE_ALL_O3 = $(STANDALONE_ALL_O4:.c=.o)
STANDALONE_ALL_O2 = $(STANDALONE_ALL_O3:.f=.o)
STANDALONE_ALL_O1 = $(STANDALONE_ALL_O2:.f90=.o)
STANDALONE_ALL_O = $(STANDALONE_ALL_O1:.f90=.o)


## Everything we need for unit tests
UNITTESTS = \
	fruit_util.f90 \
	fruit.f90 \
	$(CORE_SUPPLIB) \
	test_cutoff.f90 \
	test_linearalgebra.f90 \
	test_table2d.f90 \
	test_table3d.f90 \
	test_table4d.f90 \
	run_tests.f90
UNITTESTS_O4 = $(UNITTESTS:.cpp=.o)
UNITTESTS_O3 = $(UNITTESTS_O4:.c=.o)
UNITTESTS_O2 = $(UNITTESTS_O3:.f=.o)
UNITTESTS_O1 = $(UNITTESTS_O2:.f90=.o)
UNITTESTS_O = $(UNITTESTS_O1:.f90=.o)


## Main exectuable of standalone code
MAIN = \
	main.f90
MAIN_O = $(MAIN:.f90=.o)


## Rules
.f.o:
	$(FC) $(FFLAGS) -c $^ -o $@

.f90.o:
	$(F90C) $(F90FLAGS) -c $^ -o $@

.c.o:
	$(CC) $(CFLAGS) -c $^ -o $@

.cpp.o:
	$(CXX) $(CFLAGS) -c $^ -o $@

.cc.o:
	$(CXX) $(CFLAGS) -c $^ -o $@

.cu.o:
	$(NVCC) $(CUFLAGS) -c $^ -o $@

# Dont't optimze factories and dispatch. There is nothing to optimize, but
# compiler tends to choke on these files.
%_factory_f90.o: F90FLAGS += -O0
%_dispatch.o: F90FLAGS += -O0

versioninfo.f90:
	bash $(SRCDIR)/gen_versioninfo.sh $(SRCDIR) $(BINDIR) $(FC) $(F90FLAGS)


# Targets
#
# Exclude compilation of certain modules here by adding a --exlude flag, see below.
#
lammps_factories:
	rm -f potentials.classes
	echo "POTENTIALS_MOD =" > _Makefile.modules
	echo "#ifndef __HAVE_INC" > have.inc
	echo "#define __HAVE_INC" >> have.inc
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR)/potentials potentials potentials.classes _Makefile.modules have.inc $(INCLUDEFLAGS)
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR)/potentials_nonfree potentials potentials.classes _Makefile.modules have.inc $(INCLUDEFLAGS)  
	echo "#endif" >> have.inc
	python3 $(SRCDIR)/lammps/gen_factory.py $(SRCDIR)/lammps $(FC) $(MACHINE) $(SYSTEM)

factories:
	rm -f _Makefile.modules callables.classes coulomb.classes integrators.classes potentials.classes
	echo "#ifndef __HAVE_INC" > have.inc
	echo "#define __HAVE_INC" >> have.inc
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR) callables callables.classes _Makefile.modules have.inc $(INCLUDEFLAGS)
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR) coulomb coulomb.classes _Makefile.modules have.inc $(INCLUDEFLAGS)
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR) integrators integrators.classes _Makefile.modules have.inc $(INCLUDEFLAGS)
	python3 $(SRCDIR)/../tools/listclasses.py $(SRCDIR) potentials potentials.classes _Makefile.modules have.inc $(INCLUDEFLAGS)
	echo "#endif" >> have.inc
	awk -F ':' '{ print "use "$$1 }' integrators.classes > integrators.inc
	awk -F ':' '{ print "use "$$1 }' callables.classes > callables.inc
	awk -F ':' '{ print "use "$$1 }' coulomb.classes > coulomb.inc
	awk -F ':' '{ print "use "$$1 }' potentials.classes > potentials.inc
	python3 $(SRCDIR)/standalone/gen_factory.py $(SRCDIR)/standalone $(FC) $(MACHINE) $(SYSTEM)
	python3 $(SRCDIR)/standalone/gen_dispatch.py

versioninfo:
	bash $(SRCDIR)/gen_versioninfo.sh $(SRCDIR) $(BINDIR) $(FC) $(F90FLAGS)

atomistica: versioninfo $(LAMMPS_ALL_O)
	$(LIBTOOL) libatomistica.a $(LAMMPS_ALL_O)

mdcore: versioninfo $(STANDALONE_ALL_O) $(MAIN_O)
	$(LD) $(LDFLAGS) $(STANDALONE_ALL_O) $(MAIN_O) -o $(BINDIR)/$@-$(shell cd .. ; python3 -c "from __future__ import print_function; import versioneer; print(versioneer.get_version())")") $(LIBS)

unittests: versioninfo $(UNITTESTS_O)
	$(F90C) -o unittests $(UNITTESTS_O) $(LIBS)

clean:
	rm -f *.o *.a
	rm -f *.mod
	rm -f *.c *.h *.f90
	rm -f *.classes
	rm -f have.inc _Makefile.modules

