# vrt_lss_routing
Программный интерфейс для получения маршрутов и матриц расстояний

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.1.155313
- Package version: 2.1.155313
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_routing 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_routing
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import vrt_lss_routing
from vrt_lss_routing.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = vrt_lss_routing.CheckApi(vrt_lss_routing.ApiClient(configuration))

try:
    # Проверка доступности сервиса
    api_response = api_instance.check()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CheckApi->check: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CheckApi* | [**check**](docs/CheckApi.md#check) | **GET** /routing/check | Проверка доступности сервиса
*MatrixApi* | [**build_matrix**](docs/MatrixApi.md#build_matrix) | **POST** /routing/matrix | Построение матрицы расстояний и времени
*RouteApi* | [**build_route**](docs/RouteApi.md#build_route) | **POST** /routing/route | Построение маршрут точка-точка

## Documentation For Models

 - [CheckResult](docs/CheckResult.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse406](docs/InlineResponse406.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [MatrixLine](docs/MatrixLine.md)
 - [MatrixResult](docs/MatrixResult.md)
 - [Route](docs/Route.md)
 - [RouteLeg](docs/RouteLeg.md)
 - [RoutePolyline](docs/RoutePolyline.md)
 - [RouteResult](docs/RouteResult.md)
 - [RouteStatistics](docs/RouteStatistics.md)
 - [RouteStatisticsTimeWindow](docs/RouteStatisticsTimeWindow.md)
 - [RouteStep](docs/RouteStep.md)
 - [RoutingMatrix](docs/RoutingMatrix.md)
 - [RoutingTask](docs/RoutingTask.md)
 - [TraceData](docs/TraceData.md)
 - [TransportType](docs/TransportType.md)
 - [Waypoint](docs/Waypoint.md)

## Documentation For Authorization


## ApiKeyAuth



## Author

support@veeroute.com
