# Generated by Django 2.2 on 2020-05-03 09:20

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Setting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=100, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Instance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=100)),
                ('setting', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='settings.Setting')),
            ],
            options={
                'ordering': ('setting__name', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Field',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('public', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=100)),
                ('setting', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='settings.Setting')),
            ],
            options={
                'ordering': ('setting__name', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Value',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=100)),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='settings.Field')),
                ('instance', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='settings.Instance')),
            ],
            options={
                'unique_together': {('field', 'instance')},
            },
        ),
        migrations.AddConstraint(
            model_name='instance',
            constraint=models.UniqueConstraint(fields=('setting', 'name'), name='unique instance'),
        ),
        migrations.AddConstraint(
            model_name='field',
            constraint=models.UniqueConstraint(fields=('setting', 'name'), name='unique field'),
        ),
    ]
