# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectFileDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'size': 'int',
        'last_modified_on': 'int',
        'category_key': 'str',
        'language_relation': 'LanguageRelationDto',
        'added_by': 'ProjectFileAddedByDto',
        'added_in_step': 'int',
        'added_in_job': 'str',
        'added_in_last_step': 'bool',
        'shared_with_jobs': 'list[str]',
        'remote_cat_tool_references': 'RemoteCATToolReferencesDto',
        'url': 'str',
        'is_accepted': 'bool',
        'is_link': 'bool',
        'is_remote': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'size': 'size',
        'last_modified_on': 'lastModifiedOn',
        'category_key': 'categoryKey',
        'language_relation': 'languageRelation',
        'added_by': 'addedBy',
        'added_in_step': 'addedInStep',
        'added_in_job': 'addedInJob',
        'added_in_last_step': 'addedInLastStep',
        'shared_with_jobs': 'sharedWithJobs',
        'remote_cat_tool_references': 'remoteCATToolReferences',
        'url': 'url',
        'is_accepted': 'isAccepted',
        'is_link': 'isLink',
        'is_remote': 'isRemote'
    }

    def __init__(self, id=None, name=None, size=None, last_modified_on=None, category_key=None, language_relation=None, added_by=None, added_in_step=None, added_in_job=None, added_in_last_step=None, shared_with_jobs=None, remote_cat_tool_references=None, url=None, is_accepted=None, is_link=None, is_remote=None):  # noqa: E501
        """ProjectFileDto - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._size = None
        self._last_modified_on = None
        self._category_key = None
        self._language_relation = None
        self._added_by = None
        self._added_in_step = None
        self._added_in_job = None
        self._added_in_last_step = None
        self._shared_with_jobs = None
        self._remote_cat_tool_references = None
        self._url = None
        self._is_accepted = None
        self._is_link = None
        self._is_remote = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if size is not None:
            self.size = size
        if last_modified_on is not None:
            self.last_modified_on = last_modified_on
        if category_key is not None:
            self.category_key = category_key
        if language_relation is not None:
            self.language_relation = language_relation
        if added_by is not None:
            self.added_by = added_by
        if added_in_step is not None:
            self.added_in_step = added_in_step
        if added_in_job is not None:
            self.added_in_job = added_in_job
        if added_in_last_step is not None:
            self.added_in_last_step = added_in_last_step
        if shared_with_jobs is not None:
            self.shared_with_jobs = shared_with_jobs
        if remote_cat_tool_references is not None:
            self.remote_cat_tool_references = remote_cat_tool_references
        if url is not None:
            self.url = url
        if is_accepted is not None:
            self.is_accepted = is_accepted
        if is_link is not None:
            self.is_link = is_link
        if is_remote is not None:
            self.is_remote = is_remote

    @property
    def id(self):
        """Gets the id of this ProjectFileDto.  # noqa: E501


        :return: The id of this ProjectFileDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProjectFileDto.


        :param id: The id of this ProjectFileDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ProjectFileDto.  # noqa: E501


        :return: The name of this ProjectFileDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectFileDto.


        :param name: The name of this ProjectFileDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def size(self):
        """Gets the size of this ProjectFileDto.  # noqa: E501


        :return: The size of this ProjectFileDto.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this ProjectFileDto.


        :param size: The size of this ProjectFileDto.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def last_modified_on(self):
        """Gets the last_modified_on of this ProjectFileDto.  # noqa: E501


        :return: The last_modified_on of this ProjectFileDto.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_on

    @last_modified_on.setter
    def last_modified_on(self, last_modified_on):
        """Sets the last_modified_on of this ProjectFileDto.


        :param last_modified_on: The last_modified_on of this ProjectFileDto.  # noqa: E501
        :type: int
        """

        self._last_modified_on = last_modified_on

    @property
    def category_key(self):
        """Gets the category_key of this ProjectFileDto.  # noqa: E501


        :return: The category_key of this ProjectFileDto.  # noqa: E501
        :rtype: str
        """
        return self._category_key

    @category_key.setter
    def category_key(self, category_key):
        """Sets the category_key of this ProjectFileDto.


        :param category_key: The category_key of this ProjectFileDto.  # noqa: E501
        :type: str
        """

        self._category_key = category_key

    @property
    def language_relation(self):
        """Gets the language_relation of this ProjectFileDto.  # noqa: E501


        :return: The language_relation of this ProjectFileDto.  # noqa: E501
        :rtype: LanguageRelationDto
        """
        return self._language_relation

    @language_relation.setter
    def language_relation(self, language_relation):
        """Sets the language_relation of this ProjectFileDto.


        :param language_relation: The language_relation of this ProjectFileDto.  # noqa: E501
        :type: LanguageRelationDto
        """

        self._language_relation = language_relation

    @property
    def added_by(self):
        """Gets the added_by of this ProjectFileDto.  # noqa: E501


        :return: The added_by of this ProjectFileDto.  # noqa: E501
        :rtype: ProjectFileAddedByDto
        """
        return self._added_by

    @added_by.setter
    def added_by(self, added_by):
        """Sets the added_by of this ProjectFileDto.


        :param added_by: The added_by of this ProjectFileDto.  # noqa: E501
        :type: ProjectFileAddedByDto
        """

        self._added_by = added_by

    @property
    def added_in_step(self):
        """Gets the added_in_step of this ProjectFileDto.  # noqa: E501


        :return: The added_in_step of this ProjectFileDto.  # noqa: E501
        :rtype: int
        """
        return self._added_in_step

    @added_in_step.setter
    def added_in_step(self, added_in_step):
        """Sets the added_in_step of this ProjectFileDto.


        :param added_in_step: The added_in_step of this ProjectFileDto.  # noqa: E501
        :type: int
        """

        self._added_in_step = added_in_step

    @property
    def added_in_job(self):
        """Gets the added_in_job of this ProjectFileDto.  # noqa: E501


        :return: The added_in_job of this ProjectFileDto.  # noqa: E501
        :rtype: str
        """
        return self._added_in_job

    @added_in_job.setter
    def added_in_job(self, added_in_job):
        """Sets the added_in_job of this ProjectFileDto.


        :param added_in_job: The added_in_job of this ProjectFileDto.  # noqa: E501
        :type: str
        """

        self._added_in_job = added_in_job

    @property
    def added_in_last_step(self):
        """Gets the added_in_last_step of this ProjectFileDto.  # noqa: E501


        :return: The added_in_last_step of this ProjectFileDto.  # noqa: E501
        :rtype: bool
        """
        return self._added_in_last_step

    @added_in_last_step.setter
    def added_in_last_step(self, added_in_last_step):
        """Sets the added_in_last_step of this ProjectFileDto.


        :param added_in_last_step: The added_in_last_step of this ProjectFileDto.  # noqa: E501
        :type: bool
        """

        self._added_in_last_step = added_in_last_step

    @property
    def shared_with_jobs(self):
        """Gets the shared_with_jobs of this ProjectFileDto.  # noqa: E501


        :return: The shared_with_jobs of this ProjectFileDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._shared_with_jobs

    @shared_with_jobs.setter
    def shared_with_jobs(self, shared_with_jobs):
        """Sets the shared_with_jobs of this ProjectFileDto.


        :param shared_with_jobs: The shared_with_jobs of this ProjectFileDto.  # noqa: E501
        :type: list[str]
        """

        self._shared_with_jobs = shared_with_jobs

    @property
    def remote_cat_tool_references(self):
        """Gets the remote_cat_tool_references of this ProjectFileDto.  # noqa: E501


        :return: The remote_cat_tool_references of this ProjectFileDto.  # noqa: E501
        :rtype: RemoteCATToolReferencesDto
        """
        return self._remote_cat_tool_references

    @remote_cat_tool_references.setter
    def remote_cat_tool_references(self, remote_cat_tool_references):
        """Sets the remote_cat_tool_references of this ProjectFileDto.


        :param remote_cat_tool_references: The remote_cat_tool_references of this ProjectFileDto.  # noqa: E501
        :type: RemoteCATToolReferencesDto
        """

        self._remote_cat_tool_references = remote_cat_tool_references

    @property
    def url(self):
        """Gets the url of this ProjectFileDto.  # noqa: E501


        :return: The url of this ProjectFileDto.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ProjectFileDto.


        :param url: The url of this ProjectFileDto.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def is_accepted(self):
        """Gets the is_accepted of this ProjectFileDto.  # noqa: E501


        :return: The is_accepted of this ProjectFileDto.  # noqa: E501
        :rtype: bool
        """
        return self._is_accepted

    @is_accepted.setter
    def is_accepted(self, is_accepted):
        """Sets the is_accepted of this ProjectFileDto.


        :param is_accepted: The is_accepted of this ProjectFileDto.  # noqa: E501
        :type: bool
        """

        self._is_accepted = is_accepted

    @property
    def is_link(self):
        """Gets the is_link of this ProjectFileDto.  # noqa: E501


        :return: The is_link of this ProjectFileDto.  # noqa: E501
        :rtype: bool
        """
        return self._is_link

    @is_link.setter
    def is_link(self, is_link):
        """Sets the is_link of this ProjectFileDto.


        :param is_link: The is_link of this ProjectFileDto.  # noqa: E501
        :type: bool
        """

        self._is_link = is_link

    @property
    def is_remote(self):
        """Gets the is_remote of this ProjectFileDto.  # noqa: E501


        :return: The is_remote of this ProjectFileDto.  # noqa: E501
        :rtype: bool
        """
        return self._is_remote

    @is_remote.setter
    def is_remote(self, is_remote):
        """Sets the is_remote of this ProjectFileDto.


        :param is_remote: The is_remote of this ProjectFileDto.  # noqa: E501
        :type: bool
        """

        self._is_remote = is_remote

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectFileDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectFileDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
