# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class JobTypeDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'active': 'bool',
        'preferred': 'bool',
        'files_needed': 'bool',
        'provided_by_client': 'bool',
        'relation_to_language': 'str',
        'calculation_unit_ids': 'list[int]',
        'vendor_productivity': 'float',
        'vendor_productivity_calculation_unit_id': 'int',
        'default': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'active': 'active',
        'preferred': 'preferred',
        'files_needed': 'filesNeeded',
        'provided_by_client': 'providedByClient',
        'relation_to_language': 'relationToLanguage',
        'calculation_unit_ids': 'calculationUnitIds',
        'vendor_productivity': 'vendorProductivity',
        'vendor_productivity_calculation_unit_id': 'vendorProductivityCalculationUnitId',
        'default': 'default'
    }

    def __init__(self, id=None, name=None, active=None, preferred=None, files_needed=None, provided_by_client=None, relation_to_language=None, calculation_unit_ids=None, vendor_productivity=None, vendor_productivity_calculation_unit_id=None, default=None):  # noqa: E501
        """JobTypeDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._active = None
        self._preferred = None
        self._files_needed = None
        self._provided_by_client = None
        self._relation_to_language = None
        self._calculation_unit_ids = None
        self._vendor_productivity = None
        self._vendor_productivity_calculation_unit_id = None
        self._default = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if active is not None:
            self.active = active
        if preferred is not None:
            self.preferred = preferred
        if files_needed is not None:
            self.files_needed = files_needed
        if provided_by_client is not None:
            self.provided_by_client = provided_by_client
        if relation_to_language is not None:
            self.relation_to_language = relation_to_language
        if calculation_unit_ids is not None:
            self.calculation_unit_ids = calculation_unit_ids
        if vendor_productivity is not None:
            self.vendor_productivity = vendor_productivity
        if vendor_productivity_calculation_unit_id is not None:
            self.vendor_productivity_calculation_unit_id = vendor_productivity_calculation_unit_id
        if default is not None:
            self.default = default

    @property
    def id(self):
        """Gets the id of this JobTypeDTO.  # noqa: E501

        internal identifier  # noqa: E501

        :return: The id of this JobTypeDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobTypeDTO.

        internal identifier  # noqa: E501

        :param id: The id of this JobTypeDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this JobTypeDTO.  # noqa: E501

        localised name (formatted in the current user's locale)  # noqa: E501

        :return: The name of this JobTypeDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JobTypeDTO.

        localised name (formatted in the current user's locale)  # noqa: E501

        :param name: The name of this JobTypeDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def active(self):
        """Gets the active of this JobTypeDTO.  # noqa: E501

        should this value be available on the XTRF selection lists  # noqa: E501

        :return: The active of this JobTypeDTO.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this JobTypeDTO.

        should this value be available on the XTRF selection lists  # noqa: E501

        :param active: The active of this JobTypeDTO.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def preferred(self):
        """Gets the preferred of this JobTypeDTO.  # noqa: E501

        should this value be available on the top of XTRF selection lists, in the Preferred section  # noqa: E501

        :return: The preferred of this JobTypeDTO.  # noqa: E501
        :rtype: bool
        """
        return self._preferred

    @preferred.setter
    def preferred(self, preferred):
        """Sets the preferred of this JobTypeDTO.

        should this value be available on the top of XTRF selection lists, in the Preferred section  # noqa: E501

        :param preferred: The preferred of this JobTypeDTO.  # noqa: E501
        :type: bool
        """

        self._preferred = preferred

    @property
    def files_needed(self):
        """Gets the files_needed of this JobTypeDTO.  # noqa: E501


        :return: The files_needed of this JobTypeDTO.  # noqa: E501
        :rtype: bool
        """
        return self._files_needed

    @files_needed.setter
    def files_needed(self, files_needed):
        """Sets the files_needed of this JobTypeDTO.


        :param files_needed: The files_needed of this JobTypeDTO.  # noqa: E501
        :type: bool
        """

        self._files_needed = files_needed

    @property
    def provided_by_client(self):
        """Gets the provided_by_client of this JobTypeDTO.  # noqa: E501


        :return: The provided_by_client of this JobTypeDTO.  # noqa: E501
        :rtype: bool
        """
        return self._provided_by_client

    @provided_by_client.setter
    def provided_by_client(self, provided_by_client):
        """Sets the provided_by_client of this JobTypeDTO.


        :param provided_by_client: The provided_by_client of this JobTypeDTO.  # noqa: E501
        :type: bool
        """

        self._provided_by_client = provided_by_client

    @property
    def relation_to_language(self):
        """Gets the relation_to_language of this JobTypeDTO.  # noqa: E501


        :return: The relation_to_language of this JobTypeDTO.  # noqa: E501
        :rtype: str
        """
        return self._relation_to_language

    @relation_to_language.setter
    def relation_to_language(self, relation_to_language):
        """Sets the relation_to_language of this JobTypeDTO.


        :param relation_to_language: The relation_to_language of this JobTypeDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["LANGUAGE_COMBINATION_RELATED", "SOURCE_LANGUAGE_RELATED_ONLY", "TARGET_LANGUAGE_RELATED_ONLY", "LANGUAGE_INDEPENDENT"]  # noqa: E501
        if relation_to_language not in allowed_values:
            raise ValueError(
                "Invalid value for `relation_to_language` ({0}), must be one of {1}"  # noqa: E501
                .format(relation_to_language, allowed_values)
            )

        self._relation_to_language = relation_to_language

    @property
    def calculation_unit_ids(self):
        """Gets the calculation_unit_ids of this JobTypeDTO.  # noqa: E501


        :return: The calculation_unit_ids of this JobTypeDTO.  # noqa: E501
        :rtype: list[int]
        """
        return self._calculation_unit_ids

    @calculation_unit_ids.setter
    def calculation_unit_ids(self, calculation_unit_ids):
        """Sets the calculation_unit_ids of this JobTypeDTO.


        :param calculation_unit_ids: The calculation_unit_ids of this JobTypeDTO.  # noqa: E501
        :type: list[int]
        """

        self._calculation_unit_ids = calculation_unit_ids

    @property
    def vendor_productivity(self):
        """Gets the vendor_productivity of this JobTypeDTO.  # noqa: E501


        :return: The vendor_productivity of this JobTypeDTO.  # noqa: E501
        :rtype: float
        """
        return self._vendor_productivity

    @vendor_productivity.setter
    def vendor_productivity(self, vendor_productivity):
        """Sets the vendor_productivity of this JobTypeDTO.


        :param vendor_productivity: The vendor_productivity of this JobTypeDTO.  # noqa: E501
        :type: float
        """

        self._vendor_productivity = vendor_productivity

    @property
    def vendor_productivity_calculation_unit_id(self):
        """Gets the vendor_productivity_calculation_unit_id of this JobTypeDTO.  # noqa: E501


        :return: The vendor_productivity_calculation_unit_id of this JobTypeDTO.  # noqa: E501
        :rtype: int
        """
        return self._vendor_productivity_calculation_unit_id

    @vendor_productivity_calculation_unit_id.setter
    def vendor_productivity_calculation_unit_id(self, vendor_productivity_calculation_unit_id):
        """Sets the vendor_productivity_calculation_unit_id of this JobTypeDTO.


        :param vendor_productivity_calculation_unit_id: The vendor_productivity_calculation_unit_id of this JobTypeDTO.  # noqa: E501
        :type: int
        """

        self._vendor_productivity_calculation_unit_id = vendor_productivity_calculation_unit_id

    @property
    def default(self):
        """Gets the default of this JobTypeDTO.  # noqa: E501

        should this value be set by default in XTRF selection lists  # noqa: E501

        :return: The default of this JobTypeDTO.  # noqa: E501
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this JobTypeDTO.

        should this value be set by default in XTRF selection lists  # noqa: E501

        :param default: The default of this JobTypeDTO.  # noqa: E501
        :type: bool
        """

        self._default = default

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JobTypeDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobTypeDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
