# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FileLinkCategorizationDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category': 'str',
        'language_ids': 'list[int]',
        'language_combination_ids': 'list[LanguageCombinationDto]',
        'url': 'str',
        'filename': 'str'
    }

    attribute_map = {
        'category': 'category',
        'language_ids': 'languageIds',
        'language_combination_ids': 'languageCombinationIds',
        'url': 'url',
        'filename': 'filename'
    }

    def __init__(self, category=None, language_ids=None, language_combination_ids=None, url=None, filename=None):  # noqa: E501
        """FileLinkCategorizationDto - a model defined in Swagger"""  # noqa: E501
        self._category = None
        self._language_ids = None
        self._language_combination_ids = None
        self._url = None
        self._filename = None
        self.discriminator = None
        if category is not None:
            self.category = category
        if language_ids is not None:
            self.language_ids = language_ids
        if language_combination_ids is not None:
            self.language_combination_ids = language_combination_ids
        if url is not None:
            self.url = url
        if filename is not None:
            self.filename = filename

    @property
    def category(self):
        """Gets the category of this FileLinkCategorizationDto.  # noqa: E501


        :return: The category of this FileLinkCategorizationDto.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this FileLinkCategorizationDto.


        :param category: The category of this FileLinkCategorizationDto.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def language_ids(self):
        """Gets the language_ids of this FileLinkCategorizationDto.  # noqa: E501


        :return: The language_ids of this FileLinkCategorizationDto.  # noqa: E501
        :rtype: list[int]
        """
        return self._language_ids

    @language_ids.setter
    def language_ids(self, language_ids):
        """Sets the language_ids of this FileLinkCategorizationDto.


        :param language_ids: The language_ids of this FileLinkCategorizationDto.  # noqa: E501
        :type: list[int]
        """

        self._language_ids = language_ids

    @property
    def language_combination_ids(self):
        """Gets the language_combination_ids of this FileLinkCategorizationDto.  # noqa: E501


        :return: The language_combination_ids of this FileLinkCategorizationDto.  # noqa: E501
        :rtype: list[LanguageCombinationDto]
        """
        return self._language_combination_ids

    @language_combination_ids.setter
    def language_combination_ids(self, language_combination_ids):
        """Sets the language_combination_ids of this FileLinkCategorizationDto.


        :param language_combination_ids: The language_combination_ids of this FileLinkCategorizationDto.  # noqa: E501
        :type: list[LanguageCombinationDto]
        """

        self._language_combination_ids = language_combination_ids

    @property
    def url(self):
        """Gets the url of this FileLinkCategorizationDto.  # noqa: E501


        :return: The url of this FileLinkCategorizationDto.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this FileLinkCategorizationDto.


        :param url: The url of this FileLinkCategorizationDto.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def filename(self):
        """Gets the filename of this FileLinkCategorizationDto.  # noqa: E501


        :return: The filename of this FileLinkCategorizationDto.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this FileLinkCategorizationDto.


        :param filename: The filename of this FileLinkCategorizationDto.  # noqa: E501
        :type: str
        """

        self._filename = filename

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileLinkCategorizationDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileLinkCategorizationDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
