# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_api.api_client import ApiClient


class QuotesSmartV2Api(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_files2(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds files to the quote as added by PM.  # noqa: E501

        Adds files to the quote as added by PM. The files have to be uploaded beforehand (see \"POST v2/quotes/{quoteId}/files/upload\" operation). The following properties can be specified for each file:<ul><li>category (required, 400 Bad Request is returned otherwise)</li><li>languageIds – when the file category depends on a list of languages</li><li>languageCombinationIds – when the file category depends on a list of language combinations</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_files2(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Added files to the quote as added by PM. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_files2_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_files2_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def add_files2_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds files to the quote as added by PM.  # noqa: E501

        Adds files to the quote as added by PM. The files have to be uploaded beforehand (see \"POST v2/quotes/{quoteId}/files/upload\" operation). The following properties can be specified for each file:<ul><li>category (required, 400 Bad Request is returned otherwise)</li><li>languageIds – when the file category depends on a list of languages</li><li>languageCombinationIds – when the file category depends on a list of language combinations</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_files2_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Added files to the quote as added by PM. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_files2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_files2`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `add_files2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/files/add', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive1(self, body, **kwargs):  # noqa: E501
        """Prepares a ZIP archive that contains the specified files.  # noqa: E501

        Prepares a ZIP archive that contains the specified files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive1(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FilesDto body: Prepared ZIP archive that contains the specified files. (required)
        :return: FilesArchiveDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive1_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.archive1_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def archive1_with_http_info(self, body, **kwargs):  # noqa: E501
        """Prepares a ZIP archive that contains the specified files.  # noqa: E501

        Prepares a ZIP archive that contains the specified files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FilesDto body: Prepared ZIP archive that contains the specified files. (required)
        :return: FilesArchiveDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `archive1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/files/archive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilesArchiveDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_status2(self, body, quote_id, **kwargs):  # noqa: E501
        """Changes quote status if possible (400 Bad Request is returned otherwise).  # noqa: E501

        Changes quote status if possible (400 Bad Request is returned otherwise). The status has to be specified using one of the following keys: <ul><li>PENDING – available when the job has one of the following statuses: REQUESTED, REJECTED</li><li>SENT – available when the job has one of the following statuses: PENDING</li><li>APPROVED – available when the job has one of the following statuses: REQUESTED, PENDING, SENT, APPROVED_BY_CLIENT</li><li>REJECTED – available when the job has one of the following statuses: REQUESTED, PENDING, SENT</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_status2(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectStatusDTO body: Changed Quote status. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.change_status2_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.change_status2_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def change_status2_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Changes quote status if possible (400 Bad Request is returned otherwise).  # noqa: E501

        Changes quote status if possible (400 Bad Request is returned otherwise). The status has to be specified using one of the following keys: <ul><li>PENDING – available when the job has one of the following statuses: REQUESTED, REJECTED</li><li>SENT – available when the job has one of the following statuses: PENDING</li><li>APPROVED – available when the job has one of the following statuses: REQUESTED, PENDING, SENT, APPROVED_BY_CLIENT</li><li>REJECTED – available when the job has one of the following statuses: REQUESTED, PENDING, SENT</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_status2_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectStatusDTO body: Changed Quote status. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_status2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_status2`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `change_status2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create3(self, **kwargs):  # noqa: E501
        """Creates a new Smart Quote.  # noqa: E501

        Creates a new Smart Quote. If the specified service ID refers to Classic Quote, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create3(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuoteCreateDTO body: Project to create
        :return: QuoteDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create3_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create3_with_http_info(**kwargs)  # noqa: E501
            return data

    def create3_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new Smart Quote.  # noqa: E501

        Creates a new Smart Quote. If the specified service ID refers to Classic Quote, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create3_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuoteCreateDTO body: Project to create
        :return: QuoteDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create3" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuoteDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_payable1(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds a payable to a quote.  # noqa: E501

        Adds a payable to a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payable1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayableCreateDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: PayableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payable1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payable1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def create_payable1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds a payable to a quote.  # noqa: E501

        Adds a payable to a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payable1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayableCreateDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: PayableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payable1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payable1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `create_payable1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/payables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PayableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_receivable1(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds a receivable to a quote.  # noqa: E501

        Adds a receivable to a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_receivable1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReceivableCreateDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: ReceivableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_receivable1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_receivable1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def create_receivable1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Adds a receivable to a quote.  # noqa: E501

        Adds a receivable to a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_receivable1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReceivableCreateDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: ReceivableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_receivable1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_receivable1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `create_receivable1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/receivables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceivableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payable(self, quote_id, payable_id, **kwargs):  # noqa: E501
        """Deletes a payable.  # noqa: E501

        Deletes a payable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payable(quote_id, payable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :param int payable_id: payable's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payable_with_http_info(quote_id, payable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payable_with_http_info(quote_id, payable_id, **kwargs)  # noqa: E501
            return data

    def delete_payable_with_http_info(self, quote_id, payable_id, **kwargs):  # noqa: E501
        """Deletes a payable.  # noqa: E501

        Deletes a payable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payable_with_http_info(quote_id, payable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :param int payable_id: payable's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id', 'payable_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `delete_payable`")  # noqa: E501
        # verify the required parameter 'payable_id' is set
        if ('payable_id' not in params or
                params['payable_id'] is None):
            raise ValueError("Missing the required parameter `payable_id` when calling `delete_payable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501
        if 'payable_id' in params:
            path_params['payableId'] = params['payable_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/payables/{payableId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_receivable(self, quote_id, receivable_id, **kwargs):  # noqa: E501
        """Deletes a receivable.  # noqa: E501

        Deletes a receivable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_receivable(quote_id, receivable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :param int receivable_id: receivable's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_receivable_with_http_info(quote_id, receivable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_receivable_with_http_info(quote_id, receivable_id, **kwargs)  # noqa: E501
            return data

    def delete_receivable_with_http_info(self, quote_id, receivable_id, **kwargs):  # noqa: E501
        """Deletes a receivable.  # noqa: E501

        Deletes a receivable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_receivable_with_http_info(quote_id, receivable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :param int receivable_id: receivable's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id', 'receivable_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_receivable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `delete_receivable`")  # noqa: E501
        # verify the required parameter 'receivable_id' is set
        if ('receivable_id' not in params or
                params['receivable_id'] is None):
            raise ValueError("Missing the required parameter `receivable_id` when calling `delete_receivable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501
        if 'receivable_id' in params:
            path_params['receivableId'] = params['receivable_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/receivables/{receivableId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id10(self, quote_id, **kwargs):  # noqa: E501
        """Returns quote details.  # noqa: E501

        Returns quote details. If the specified quote ID refers to Classic Quote, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id10(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: QuoteDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id10_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id10_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_by_id10_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns quote details.  # noqa: E501

        Returns quote details. If the specified quote ID refers to Classic Quote, 400 Bad Request is returned instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id10_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: QuoteDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id10" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_by_id10`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuoteDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contacts3(self, quote_id, **kwargs):  # noqa: E501
        """Returns Client Contacts information for a quote.  # noqa: E501

        Returns Client Contacts information for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts3(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: SmartContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contacts3_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contacts3_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_contacts3_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns Client Contacts information for a quote.  # noqa: E501

        Returns Client Contacts information for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts3_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: SmartContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contacts3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_contacts3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/clientContacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_custom_fields9(self, quote_id, **kwargs):  # noqa: E501
        """Returns a list of custom field keys and values for a project.  # noqa: E501

        Returns a list of custom field keys and values for a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields9(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_custom_fields9_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_custom_fields9_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_custom_fields9_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns a list of custom field keys and values for a project.  # noqa: E501

        Returns a list of custom field keys and values for a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_custom_fields9_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: CustomFieldsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_fields9" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_custom_fields9`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_by_id2(self, file_id, **kwargs):  # noqa: E501
        """Returns details of a file.  # noqa: E501

        Returns details of a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_id2(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: file's internal identifier (required)
        :return: ProjectFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_by_id2_with_http_info(file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_by_id2_with_http_info(file_id, **kwargs)  # noqa: E501
            return data

    def get_file_by_id2_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Returns details of a file.  # noqa: E501

        Returns details of a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_id2_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: file's internal identifier (required)
        :return: ProjectFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_by_id2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_file_by_id2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/files/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectFileDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_content_by_id1(self, file_id, file_name, **kwargs):  # noqa: E501
        """Downloads a file content.  # noqa: E501

        Downloads a file content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_content_by_id1(file_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: file's internal identifier (required)
        :param str file_name: file's name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_content_by_id1_with_http_info(file_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_content_by_id1_with_http_info(file_id, file_name, **kwargs)  # noqa: E501
            return data

    def get_file_content_by_id1_with_http_info(self, file_id, file_name, **kwargs):  # noqa: E501
        """Downloads a file content.  # noqa: E501

        Downloads a file content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_content_by_id1_with_http_info(file_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: file's internal identifier (required)
        :param str file_name: file's name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_content_by_id1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_file_content_by_id1`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_file_content_by_id1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/files/{fileId}/download/{fileName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_files1(self, quote_id, **kwargs):  # noqa: E501
        """Returns list of files in a quote.  # noqa: E501

        Returns list of files in a quote. Only files added to the quote (i.e. files that have assigned category and languages) are listed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files1(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: list[ProjectFileDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_files1_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_files1_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_files1_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns list of files in a quote.  # noqa: E501

        Returns list of files in a quote. Only files added to the quote (i.e. files that have assigned category and languages) are listed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files1_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: list[ProjectFileDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_files1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProjectFileDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_finance3(self, quote_id, **kwargs):  # noqa: E501
        """Returns finance information for a quote.  # noqa: E501

        Returns finance information for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_finance3(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: FinanceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_finance3_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_finance3_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_finance3_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns finance information for a quote.  # noqa: E501

        Returns finance information for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_finance3_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: FinanceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_finance3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FinanceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_jobs1(self, quote_id, **kwargs):  # noqa: E501
        """Returns list of jobs in a quote.  # noqa: E501

        Returns list of jobs in a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_jobs1(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: list[JobDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_jobs1_with_http_info(quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_jobs1_with_http_info(quote_id, **kwargs)  # noqa: E501
            return data

    def get_jobs1_with_http_info(self, quote_id, **kwargs):  # noqa: E501
        """Returns list of jobs in a quote.  # noqa: E501

        Returns list of jobs in a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_jobs1_with_http_info(quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quote_id: quote's internal identifier (required)
        :return: list[JobDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `get_jobs1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[JobDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_business_days(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Business Days for a quote.  # noqa: E501

        Updates Business Days for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_business_days(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body: Updated Business Days for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_business_days_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_business_days_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_business_days_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Business Days for a quote.  # noqa: E501

        Updates Business Days for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_business_days_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body: Updated Business Days for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_business_days" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_business_days`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_business_days`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/businessDays', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_notes1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Notes for a quote.  # noqa: E501

        Updates Client Notes for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_notes1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Notes for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_notes1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_notes1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_client_notes1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Notes for a quote.  # noqa: E501

        Updates Client Notes for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_notes1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Notes for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_notes1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_client_notes1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_client_notes1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/clientNotes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_reference_number1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Reference Number for a quote.  # noqa: E501

        Updates Client Reference Number for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_reference_number1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Reference Number for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_reference_number1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_reference_number1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_client_reference_number1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Reference Number for a quote.  # noqa: E501

        Updates Client Reference Number for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_reference_number1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Client Reference Number for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_reference_number1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_client_reference_number1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_client_reference_number1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/clientReferenceNumber', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_contacts(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Contacts for a quote.  # noqa: E501

        Updates Client Contacts for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmartContactsDTO body: Updated Client Contacts for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: SmartContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_contacts_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_contacts_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_contacts_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Client Contacts for a quote.  # noqa: E501

        Updates Client Contacts for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_contacts_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmartContactsDTO body: Updated Client Contacts for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: SmartContactsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_contacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_contacts`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_contacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/clientContacts', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartContactsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_custom_field1(self, body, quote_id, key, **kwargs):  # noqa: E501
        """Updates a custom field with a specified key in a quote.  # noqa: E501

        Updates a custom field with a specified key in a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_field1(body, quote_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmartCustomFieldDTO body: Updated custom field with a specified key in a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :param str key: custom field's key (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_custom_field1_with_http_info(body, quote_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.update_custom_field1_with_http_info(body, quote_id, key, **kwargs)  # noqa: E501
            return data

    def update_custom_field1_with_http_info(self, body, quote_id, key, **kwargs):  # noqa: E501
        """Updates a custom field with a specified key in a quote.  # noqa: E501

        Updates a custom field with a specified key in a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_custom_field1_with_http_info(body, quote_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmartCustomFieldDTO body: Updated custom field with a specified key in a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :param str key: custom field's key (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_custom_field1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_custom_field1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_custom_field1`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `update_custom_field1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/customFields/{key}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_expected_delivery_date(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Expected Delivery Date for a quote.  # noqa: E501

        Updates Expected Delivery Date for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_expected_delivery_date(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Updated Expected Delivery Date for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_expected_delivery_date_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_expected_delivery_date_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_expected_delivery_date_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Expected Delivery Date for a quote.  # noqa: E501

        Updates Expected Delivery Date for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_expected_delivery_date_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Updated Expected Delivery Date for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_expected_delivery_date" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_expected_delivery_date`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_expected_delivery_date`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/expectedDeliveryDate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_internal_notes1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Internal Notes for a quote.  # noqa: E501

        Updates Internal Notes for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_internal_notes1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Internal Notes for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_internal_notes1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_internal_notes1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_internal_notes1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Internal Notes for a quote.  # noqa: E501

        Updates Internal Notes for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_internal_notes1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated Internal Notes for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_internal_notes1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_internal_notes1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_internal_notes1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/internalNotes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_payable1(self, body, quote_id, payable_id, **kwargs):  # noqa: E501
        """Updates a payable.  # noqa: E501

        Updates a payable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_payable1(body, quote_id, payable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayableDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :param int payable_id: payable's internal identifier (required)
        :return: PayableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_payable1_with_http_info(body, quote_id, payable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_payable1_with_http_info(body, quote_id, payable_id, **kwargs)  # noqa: E501
            return data

    def update_payable1_with_http_info(self, body, quote_id, payable_id, **kwargs):  # noqa: E501
        """Updates a payable.  # noqa: E501

        Updates a payable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_payable1_with_http_info(body, quote_id, payable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PayableDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :param int payable_id: payable's internal identifier (required)
        :return: PayableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id', 'payable_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_payable1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_payable1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_payable1`")  # noqa: E501
        # verify the required parameter 'payable_id' is set
        if ('payable_id' not in params or
                params['payable_id'] is None):
            raise ValueError("Missing the required parameter `payable_id` when calling `update_payable1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501
        if 'payable_id' in params:
            path_params['payableId'] = params['payable_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/payables/{payableId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PayableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_quote_expiry(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Quote Expiry Date for a quote.  # noqa: E501

        Updates Quote Expiry Date for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quote_expiry(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Updated Quote Expiry Date for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_quote_expiry_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_quote_expiry_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_quote_expiry_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates Quote Expiry Date for a quote.  # noqa: E501

        Updates Quote Expiry Date for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quote_expiry_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeDTO body: Updated Quote Expiry Date for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_quote_expiry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_quote_expiry`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_quote_expiry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/quoteExpiry', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_receivable1(self, body, quote_id, receivable_id, **kwargs):  # noqa: E501
        """Updates a receivable.  # noqa: E501

        Updates a receivable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_receivable1(body, quote_id, receivable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReceivableDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :param int receivable_id: receivable's internal identifier (required)
        :return: ReceivableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_receivable1_with_http_info(body, quote_id, receivable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_receivable1_with_http_info(body, quote_id, receivable_id, **kwargs)  # noqa: E501
            return data

    def update_receivable1_with_http_info(self, body, quote_id, receivable_id, **kwargs):  # noqa: E501
        """Updates a receivable.  # noqa: E501

        Updates a receivable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_receivable1_with_http_info(body, quote_id, receivable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReceivableDTO body: (required)
        :param str quote_id: quote's internal identifier (required)
        :param int receivable_id: receivable's internal identifier (required)
        :return: ReceivableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id', 'receivable_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_receivable1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_receivable1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_receivable1`")  # noqa: E501
        # verify the required parameter 'receivable_id' is set
        if ('receivable_id' not in params or
                params['receivable_id'] is None):
            raise ValueError("Missing the required parameter `receivable_id` when calling `update_receivable1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501
        if 'receivable_id' in params:
            path_params['receivableId'] = params['receivable_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/finance/receivables/{receivableId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceivableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_source_language1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates source language for a quote.  # noqa: E501

        Updates source language for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_source_language1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceLanguageDTO body: Updated source language for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_source_language1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_source_language1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_source_language1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates source language for a quote.  # noqa: E501

        Updates source language for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_source_language1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SourceLanguageDTO body: Updated source language for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_source_language1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_source_language1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_source_language1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/sourceLanguage', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_specialization1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates specialization for a quote.  # noqa: E501

        Updates specialization for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specialization1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecializationDTO body: Updated specialization for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_specialization1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_specialization1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_specialization1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates specialization for a quote.  # noqa: E501

        Updates specialization for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_specialization1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpecializationDTO body: Updated specialization for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_specialization1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_specialization1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_specialization1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/specialization', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_target_languages1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates target languages for a quote.  # noqa: E501

        Updates target languages for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_target_languages1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TargetLanguagesDTO body: Updated target languages for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_target_languages1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_target_languages1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_target_languages1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates target languages for a quote.  # noqa: E501

        Updates target languages for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_target_languages1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TargetLanguagesDTO body: Updated target languages for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_target_languages1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_target_languages1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_target_languages1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/targetLanguages', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_vendor_instructions1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates instructions for all vendors performing the jobs in a quote.  # noqa: E501

        Updates instructions for all vendors performing the jobs in a quote. See also \"PUT /jobs/{jobId}/instructions\" for updating instructions for a specific job in a project or quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_vendor_instructions1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated instructions for all vendors performing the jobs in a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_vendor_instructions1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_vendor_instructions1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_vendor_instructions1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates instructions for all vendors performing the jobs in a quote.  # noqa: E501

        Updates instructions for all vendors performing the jobs in a quote. See also \"PUT /jobs/{jobId}/instructions\" for updating instructions for a specific job in a project or quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_vendor_instructions1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StringDTO body: Updated instructions for all vendors performing the jobs in a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vendor_instructions1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_vendor_instructions1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_vendor_instructions1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/vendorInstructions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_volume1(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates volume for a quote.  # noqa: E501

        Updates volume for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_volume1(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BigDecimalDTO body: Updated volume for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_volume1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_volume1_with_http_info(body, quote_id, **kwargs)  # noqa: E501
            return data

    def update_volume1_with_http_info(self, body, quote_id, **kwargs):  # noqa: E501
        """Updates volume for a quote.  # noqa: E501

        Updates volume for a quote.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_volume1_with_http_info(body, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BigDecimalDTO body: Updated volume for a quote. (required)
        :param str quote_id: quote's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_volume1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_volume1`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `update_volume1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/volume', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_file3(self, file, file_name, quote_id, **kwargs):  # noqa: E501
        """Uploads file to the quote as a file uploaded by PM.  # noqa: E501

        Uploads file to the quote as a file uploaded by PM. Only one file can be uploaded at once. When the upload is finished the file has to be added by specifying its category and languages (see \"PUT /v2/quotes/{quoteId}/files/add\" operation).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file3(file, file_name, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str file_name: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: FileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_file3_with_http_info(file, file_name, quote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_file3_with_http_info(file, file_name, quote_id, **kwargs)  # noqa: E501
            return data

    def upload_file3_with_http_info(self, file, file_name, quote_id, **kwargs):  # noqa: E501
        """Uploads file to the quote as a file uploaded by PM.  # noqa: E501

        Uploads file to the quote as a file uploaded by PM. Only one file can be uploaded at once. When the upload is finished the file has to be added by specifying its category and languages (see \"PUT /v2/quotes/{quoteId}/files/add\" operation).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file3_with_http_info(file, file_name, quote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str file_name: (required)
        :param str quote_id: quote's internal identifier (required)
        :return: FileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'file_name', 'quote_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_file3`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `upload_file3`")  # noqa: E501
        # verify the required parameter 'quote_id' is set
        if ('quote_id' not in params or
                params['quote_id'] is None):
            raise ValueError("Missing the required parameter `quote_id` when calling `upload_file3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quote_id' in params:
            path_params['quoteId'] = params['quote_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/v2/quotes/{quoteId}/files/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
