"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemplateAssertions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const has_resource_1 = require("./has-resource");
const match_1 = require("./match");
const matcher_1 = require("./matcher");
const assert = require("./vendored/assert");
/**
 * (experimental) Suite of assertions that can be run on a CDK stack.
 *
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 *
 * @experimental
 */
class TemplateAssertions {
    constructor(template) {
        this.inspector = new assert.StackInspector(template);
    }
    /**
     * (experimental) Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @experimental
     */
    static fromStack(stack) {
        return new TemplateAssertions(toTemplate(stack));
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a nested set of records.
     *
     * @param template the CloudFormation template formatted as a nested set of records.
     * @experimental
     */
    static fromTemplate(template) {
        return new TemplateAssertions(template);
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a string.
     *
     * @param template the CloudFormation template in.
     * @experimental
     */
    static fromString(template) {
        return new TemplateAssertions(JSON.parse(template));
    }
    /**
     * (experimental) Assert that the given number of resources of the given type exist in the template.
     *
     * @param type the resource type;
     * @param count number of expected instances.
     * @experimental
     */
    resourceCountIs(type, count) {
        const assertion = assert.countResources(type, count);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that a resource of the given type and properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the `Properties` key of the resource, via the
     * `Match.objectLike()`. To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the 'Properties' section of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceProperties(type, props) {
        this.hasResource(type, match_1.Match.objectLike({
            Properties: matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props),
        }));
    }
    /**
     * (experimental) Assert that a resource of the given type and given definition exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the entire defintion of the resource as should be expected in the template.
     * @experimental
     */
    hasResource(type, props) {
        const matchError = has_resource_1.hasResource(this.inspector, type, props);
        if (matchError) {
            throw new Error(matchError);
        }
    }
    /**
     * (experimental) Assert that the CloudFormation template matches the given value.
     *
     * @param expected the expected CloudFormation template as key-value pairs.
     * @experimental
     */
    templateMatches(expected) {
        const assertion = assert.matchTemplate(expected);
        assertion.assertOrThrow(this.inspector);
    }
}
exports.TemplateAssertions = TemplateAssertions;
_a = JSII_RTTI_SYMBOL_1;
TemplateAssertions[_a] = { fqn: "@aws-cdk/assertions.TemplateAssertions", version: "1.113.0" };
function toTemplate(stack) {
    const root = stack.node.root;
    if (!core_1.Stage.isStage(root)) {
        throw new Error('unexpected: all stacks must be part of a Stage or an App');
    }
    const assembly = root.synth();
    return assembly.getStackArtifact(stack.artifactId).template;
}
//# sourceMappingURL=data:application/json;base64,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