"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
};
//# sourceMappingURL=data:application/json;base64,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