"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// output directory into which to emit synthesis outputs. CDK doesn't allow outdir
// to be specified both through the CDK_OUTDIR environment variable and the through
// aws:cdk:outdir context.
exports.OUTDIR_ENV = 'CDK_OUTDIR';
exports.CONTEXT_ENV = 'CDK_CONTEXT_JSON';
/**
 * Environment variable set by the CDK CLI with the default AWS account ID.
 */
exports.DEFAULT_ACCOUNT_ENV = 'CDK_DEFAULT_ACCOUNT';
/**
 * Environment variable set by the CDK CLI with the default AWS region.
 */
exports.DEFAULT_REGION_ENV = 'CDK_DEFAULT_REGION';
/**
 * Version of Cloud Assembly expected by CDK CLI.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_ASM_VERSION_ENV = 'CDK_CLI_ASM_VERSION';
/**
 * Version of the CLI currently running.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_VERSION_ENV = 'CDK_CLI_VERSION';
/**
 * If a context value is an object with this key, it indicates an error
 */
exports.PROVIDER_ERROR_KEY = '$providerError';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3hhcGkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjeGFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGtGQUFrRjtBQUNsRixtRkFBbUY7QUFDbkYsMEJBQTBCO0FBQ2IsUUFBQSxVQUFVLEdBQUcsWUFBWSxDQUFDO0FBQzFCLFFBQUEsV0FBVyxHQUFHLGtCQUFrQixDQUFDO0FBQzlDOztHQUVHO0FBQ1UsUUFBQSxtQkFBbUIsR0FBRyxxQkFBcUIsQ0FBQztBQUN6RDs7R0FFRztBQUNVLFFBQUEsa0JBQWtCLEdBQUcsb0JBQW9CLENBQUM7QUFDdkQ7Ozs7R0FJRztBQUNVLFFBQUEsbUJBQW1CLEdBQUcscUJBQXFCLENBQUM7QUFDekQ7Ozs7R0FJRztBQUNVLFFBQUEsZUFBZSxHQUFHLGlCQUFpQixDQUFDO0FBQ2pEOztHQUVHO0FBQ1UsUUFBQSxrQkFBa0IsR0FBRyxnQkFBZ0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIG91dHB1dCBkaXJlY3RvcnkgaW50byB3aGljaCB0byBlbWl0IHN5bnRoZXNpcyBvdXRwdXRzLiBDREsgZG9lc24ndCBhbGxvdyBvdXRkaXJcbi8vIHRvIGJlIHNwZWNpZmllZCBib3RoIHRocm91Z2ggdGhlIENES19PVVRESVIgZW52aXJvbm1lbnQgdmFyaWFibGUgYW5kIHRoZSB0aHJvdWdoXG4vLyBhd3M6Y2RrOm91dGRpciBjb250ZXh0LlxuZXhwb3J0IGNvbnN0IE9VVERJUl9FTlYgPSAnQ0RLX09VVERJUic7XG5leHBvcnQgY29uc3QgQ09OVEVYVF9FTlYgPSAnQ0RLX0NPTlRFWFRfSlNPTic7XG4vKipcbiAqIEVudmlyb25tZW50IHZhcmlhYmxlIHNldCBieSB0aGUgQ0RLIENMSSB3aXRoIHRoZSBkZWZhdWx0IEFXUyBhY2NvdW50IElELlxuICovXG5leHBvcnQgY29uc3QgREVGQVVMVF9BQ0NPVU5UX0VOViA9ICdDREtfREVGQVVMVF9BQ0NPVU5UJztcbi8qKlxuICogRW52aXJvbm1lbnQgdmFyaWFibGUgc2V0IGJ5IHRoZSBDREsgQ0xJIHdpdGggdGhlIGRlZmF1bHQgQVdTIHJlZ2lvbi5cbiAqL1xuZXhwb3J0IGNvbnN0IERFRkFVTFRfUkVHSU9OX0VOViA9ICdDREtfREVGQVVMVF9SRUdJT04nO1xuLyoqXG4gKiBWZXJzaW9uIG9mIENsb3VkIEFzc2VtYmx5IGV4cGVjdGVkIGJ5IENESyBDTEkuXG4gKlxuICogQ0xJIHN0YXJ0ZWQgZW1pdHRpbmcgdGhpcyBhdCAxLjEwLjFcbiAqL1xuZXhwb3J0IGNvbnN0IENMSV9BU01fVkVSU0lPTl9FTlYgPSAnQ0RLX0NMSV9BU01fVkVSU0lPTic7XG4vKipcbiAqIFZlcnNpb24gb2YgdGhlIENMSSBjdXJyZW50bHkgcnVubmluZy5cbiAqXG4gKiBDTEkgc3RhcnRlZCBlbWl0dGluZyB0aGlzIGF0IDEuMTAuMVxuICovXG5leHBvcnQgY29uc3QgQ0xJX1ZFUlNJT05fRU5WID0gJ0NES19DTElfVkVSU0lPTic7XG4vKipcbiAqIElmIGEgY29udGV4dCB2YWx1ZSBpcyBhbiBvYmplY3Qgd2l0aCB0aGlzIGtleSwgaXQgaW5kaWNhdGVzIGFuIGVycm9yXG4gKi9cbmV4cG9ydCBjb25zdCBQUk9WSURFUl9FUlJPUl9LRVkgPSAnJHByb3ZpZGVyRXJyb3InO1xuIl19