"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The type of subnet group.
 * Same as SubnetType in the @aws-cdk/aws-ec2 package,
 * but we can't use that because of cyclical dependencies.
 */
var VpcSubnetGroupType;
(function (VpcSubnetGroupType) {
    /** Public subnet group type. */
    VpcSubnetGroupType["PUBLIC"] = "Public";
    /** Private subnet group type. */
    VpcSubnetGroupType["PRIVATE"] = "Private";
    /** Isolated subnet group type. */
    VpcSubnetGroupType["ISOLATED"] = "Isolated";
})(VpcSubnetGroupType = exports.VpcSubnetGroupType || (exports.VpcSubnetGroupType = {}));
//# sourceMappingURL=data:application/json;base64,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