"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cxschema = require("../../cloud-assembly-schema"); // Automatically re-written from '@aws-cdk/cloud-assembly-schema'
const fs = require("fs");
const path = require("path");
const cloud_artifact_1 = require("./cloud-artifact");
const environment_1 = require("./environment");
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters || {};
        this.assumeRoleArn = properties.assumeRoleArn;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.terminationProtection = properties.terminationProtection;
        this.stackName = properties.stackName || artifactId;
        this.template = JSON.parse(fs.readFileSync(path.join(this.assembly.directory, this.templateFile), 'utf-8'));
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.stackName
            : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
//# sourceMappingURL=data:application/json;base64,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