import * as cxschema from "../../cloud-assembly-schema";
import { CloudArtifact } from './cloud-artifact';
import { CloudAssembly } from './cloud-assembly';
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
export declare class AssetManifestArtifact extends CloudArtifact {
    /**
     * The file name of the asset manifest
     */
    readonly file: string;
    /**
     * Version of bootstrap stack required to deploy this stack
     */
    readonly requiresBootstrapStackVersion: number;
    constructor(assembly: CloudAssembly, name: string, artifact: cxschema.ArtifactManifest);
}
