"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const DEFAULT_TIMEOUT = core_1.Duration.minutes(30);
const DEFAULT_INTERVAL = core_1.Duration.seconds(5);
function calculateRetryPolicy(props = {}) {
    const totalTimeout = props.totalTimeout || DEFAULT_TIMEOUT;
    const interval = props.queryInterval || DEFAULT_INTERVAL;
    const maxAttempts = totalTimeout.toSeconds() / interval.toSeconds();
    if (Math.round(maxAttempts) !== maxAttempts) {
        throw new Error(`Cannot determine retry count since totalTimeout=${totalTimeout.toSeconds()}s is not integrally dividable by queryInterval=${interval.toSeconds()}s`);
    }
    return {
        maxAttempts,
        interval,
        backoffRate: 1,
    };
}
exports.calculateRetryPolicy = calculateRetryPolicy;
//# sourceMappingURL=data:application/json;base64,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